package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FailureDomainBuilder extends FailureDomainFluent<FailureDomainBuilder> implements VisitableBuilder<FailureDomain,FailureDomainBuilder>{
  public FailureDomainBuilder() {
    this(false);
  }
  public FailureDomainBuilder(Boolean validationEnabled) {
    this(new FailureDomain(), validationEnabled);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent) {
    this(fluent, false);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FailureDomain(), validationEnabled);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent,FailureDomain instance) {
    this(fluent, instance, false);
  }
  public FailureDomainBuilder(FailureDomainFluent<?> fluent,FailureDomain instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new FailureDomain());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withRegion(instance.getRegion());
      fluent.withServer(instance.getServer());
      fluent.withTopology(instance.getTopology());
      fluent.withZone(instance.getZone());
      fluent.withName(instance.getName());
      fluent.withRegion(instance.getRegion());
      fluent.withServer(instance.getServer());
      fluent.withTopology(instance.getTopology());
      fluent.withZone(instance.getZone());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FailureDomainBuilder(FailureDomain instance) {
    this(instance,false);
  }
  public FailureDomainBuilder(FailureDomain instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new FailureDomain());

    if (instance != null) {
      this.withName(instance.getName());
      this.withRegion(instance.getRegion());
      this.withServer(instance.getServer());
      this.withTopology(instance.getTopology());
      this.withZone(instance.getZone());
      this.withName(instance.getName());
      this.withRegion(instance.getRegion());
      this.withServer(instance.getServer());
      this.withTopology(instance.getTopology());
      this.withZone(instance.getZone());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FailureDomainFluent<?> fluent;
  Boolean validationEnabled;
  public FailureDomain build() {
    FailureDomain buildable = new FailureDomain(fluent.getName(),fluent.getRegion(),fluent.getServer(),fluent.buildTopology(),fluent.getZone());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}