package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TopologyBuilder extends TopologyFluent<TopologyBuilder> implements VisitableBuilder<Topology,TopologyBuilder>{
  public TopologyBuilder() {
    this(false);
  }
  public TopologyBuilder(Boolean validationEnabled) {
    this(new Topology(), validationEnabled);
  }
  public TopologyBuilder(TopologyFluent<?> fluent) {
    this(fluent, false);
  }
  public TopologyBuilder(TopologyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Topology(), validationEnabled);
  }
  public TopologyBuilder(TopologyFluent<?> fluent,Topology instance) {
    this(fluent, instance, false);
  }
  public TopologyBuilder(TopologyFluent<?> fluent,Topology instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Topology());

    if (instance != null) {
      fluent.withComputeCluster(instance.getComputeCluster());
      fluent.withDatacenter(instance.getDatacenter());
      fluent.withDatastore(instance.getDatastore());
      fluent.withFolder(instance.getFolder());
      fluent.withNetworks(instance.getNetworks());
      fluent.withResourcePool(instance.getResourcePool());
      fluent.withComputeCluster(instance.getComputeCluster());
      fluent.withDatacenter(instance.getDatacenter());
      fluent.withDatastore(instance.getDatastore());
      fluent.withFolder(instance.getFolder());
      fluent.withNetworks(instance.getNetworks());
      fluent.withResourcePool(instance.getResourcePool());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TopologyBuilder(Topology instance) {
    this(instance,false);
  }
  public TopologyBuilder(Topology instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Topology());

    if (instance != null) {
      this.withComputeCluster(instance.getComputeCluster());
      this.withDatacenter(instance.getDatacenter());
      this.withDatastore(instance.getDatastore());
      this.withFolder(instance.getFolder());
      this.withNetworks(instance.getNetworks());
      this.withResourcePool(instance.getResourcePool());
      this.withComputeCluster(instance.getComputeCluster());
      this.withDatacenter(instance.getDatacenter());
      this.withDatastore(instance.getDatastore());
      this.withFolder(instance.getFolder());
      this.withNetworks(instance.getNetworks());
      this.withResourcePool(instance.getResourcePool());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TopologyFluent<?> fluent;
  Boolean validationEnabled;
  public Topology build() {
    Topology buildable = new Topology(fluent.getComputeCluster(),fluent.getDatacenter(),fluent.getDatastore(),fluent.getFolder(),fluent.getNetworks(),fluent.getResourcePool());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}