package io.fabric8.openshift.api.model.installer.baremetal.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.config.v1.BareMetalPlatformLoadBalancer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  
  public PlatformFluent(Platform instance) {
    this.copyInstance(instance);
  }
  private String apiVIP;
  private List<String> apiVIPs = new ArrayList<String>();
  private String bootstrapExternalStaticGateway;
  private String bootstrapExternalStaticIP;
  private String bootstrapOSImage;
  private String bootstrapProvisioningIP;
  private String clusterOSImage;
  private String clusterProvisioningIP;
  private MachinePoolBuilder defaultMachinePlatform;
  private String externalBridge;
  private String externalMACAddress;
  private ArrayList<HostBuilder> hosts = new ArrayList<HostBuilder>();
  private String ingressVIP;
  private List<String> ingressVIPs = new ArrayList<String>();
  private String libvirtURI;
  private BareMetalPlatformLoadBalancer loadBalancer;
  private String provisioningBridge;
  private Boolean provisioningDHCPExternal;
  private String provisioningDHCPRange;
  private String provisioningHostIP;
  private String provisioningMACAddress;
  private String provisioningNetwork;
  private String provisioningNetworkCIDR;
  private String provisioningNetworkInterface;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Platform instance) {
    instance = (instance != null ? instance : new Platform());
  
    if (instance != null) {
        this.withApiVIP(instance.getApiVIP());
        this.withApiVIPs(instance.getApiVIPs());
        this.withBootstrapExternalStaticGateway(instance.getBootstrapExternalStaticGateway());
        this.withBootstrapExternalStaticIP(instance.getBootstrapExternalStaticIP());
        this.withBootstrapOSImage(instance.getBootstrapOSImage());
        this.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withClusterProvisioningIP(instance.getClusterProvisioningIP());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withExternalBridge(instance.getExternalBridge());
        this.withExternalMACAddress(instance.getExternalMACAddress());
        this.withHosts(instance.getHosts());
        this.withIngressVIP(instance.getIngressVIP());
        this.withIngressVIPs(instance.getIngressVIPs());
        this.withLibvirtURI(instance.getLibvirtURI());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withProvisioningBridge(instance.getProvisioningBridge());
        this.withProvisioningDHCPExternal(instance.getProvisioningDHCPExternal());
        this.withProvisioningDHCPRange(instance.getProvisioningDHCPRange());
        this.withProvisioningHostIP(instance.getProvisioningHostIP());
        this.withProvisioningMACAddress(instance.getProvisioningMACAddress());
        this.withProvisioningNetwork(instance.getProvisioningNetwork());
        this.withProvisioningNetworkCIDR(instance.getProvisioningNetworkCIDR());
        this.withProvisioningNetworkInterface(instance.getProvisioningNetworkInterface());
        this.withApiVIP(instance.getApiVIP());
        this.withApiVIPs(instance.getApiVIPs());
        this.withBootstrapExternalStaticGateway(instance.getBootstrapExternalStaticGateway());
        this.withBootstrapExternalStaticIP(instance.getBootstrapExternalStaticIP());
        this.withBootstrapOSImage(instance.getBootstrapOSImage());
        this.withBootstrapProvisioningIP(instance.getBootstrapProvisioningIP());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withClusterProvisioningIP(instance.getClusterProvisioningIP());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withExternalBridge(instance.getExternalBridge());
        this.withExternalMACAddress(instance.getExternalMACAddress());
        this.withHosts(instance.getHosts());
        this.withIngressVIP(instance.getIngressVIP());
        this.withIngressVIPs(instance.getIngressVIPs());
        this.withLibvirtURI(instance.getLibvirtURI());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withProvisioningBridge(instance.getProvisioningBridge());
        this.withProvisioningDHCPExternal(instance.getProvisioningDHCPExternal());
        this.withProvisioningDHCPRange(instance.getProvisioningDHCPRange());
        this.withProvisioningHostIP(instance.getProvisioningHostIP());
        this.withProvisioningMACAddress(instance.getProvisioningMACAddress());
        this.withProvisioningNetwork(instance.getProvisioningNetwork());
        this.withProvisioningNetworkCIDR(instance.getProvisioningNetworkCIDR());
        this.withProvisioningNetworkInterface(instance.getProvisioningNetworkInterface());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApiVIP() {
    return this.apiVIP;
  }
  
  public A withApiVIP(String apiVIP) {
    this.apiVIP=apiVIP; return (A) this;
  }
  
  public boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  
  public A addToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.add(index, item);
    return (A)this;
  }
  
  public A setToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.set(index, item); return (A)this;
  }
  
  public A addToApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  
  public A addAllToApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  
  public A removeFromApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  
  public List<String> getApiVIPs() {
    return this.apiVIPs;
  }
  
  public String getApiVIP(int index) {
    return this.apiVIPs.get(index);
  }
  
  public String getFirstApiVIP() {
    return this.apiVIPs.get(0);
  }
  
  public String getLastApiVIP() {
    return this.apiVIPs.get(apiVIPs.size() - 1);
  }
  
  public String getMatchingApiVIP(Predicate<String> predicate) {
    for (String item: apiVIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingApiVIP(Predicate<String> predicate) {
    for (String item: apiVIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withApiVIPs(List<String> apiVIPs) {
    if (apiVIPs != null) {this.apiVIPs = new ArrayList(); for (String item : apiVIPs){this.addToApiVIPs(item);}} else { this.apiVIPs = null;} return (A) this;
  }
  
  public A withApiVIPs(java.lang.String... apiVIPs) {
    if (this.apiVIPs != null) {this.apiVIPs.clear(); _visitables.remove("apiVIPs"); }
    if (apiVIPs != null) {for (String item :apiVIPs){ this.addToApiVIPs(item);}} return (A) this;
  }
  
  public boolean hasApiVIPs() {
    return apiVIPs != null && !apiVIPs.isEmpty();
  }
  
  public String getBootstrapExternalStaticGateway() {
    return this.bootstrapExternalStaticGateway;
  }
  
  public A withBootstrapExternalStaticGateway(String bootstrapExternalStaticGateway) {
    this.bootstrapExternalStaticGateway=bootstrapExternalStaticGateway; return (A) this;
  }
  
  public boolean hasBootstrapExternalStaticGateway() {
    return this.bootstrapExternalStaticGateway != null;
  }
  
  public String getBootstrapExternalStaticIP() {
    return this.bootstrapExternalStaticIP;
  }
  
  public A withBootstrapExternalStaticIP(String bootstrapExternalStaticIP) {
    this.bootstrapExternalStaticIP=bootstrapExternalStaticIP; return (A) this;
  }
  
  public boolean hasBootstrapExternalStaticIP() {
    return this.bootstrapExternalStaticIP != null;
  }
  
  public String getBootstrapOSImage() {
    return this.bootstrapOSImage;
  }
  
  public A withBootstrapOSImage(String bootstrapOSImage) {
    this.bootstrapOSImage=bootstrapOSImage; return (A) this;
  }
  
  public boolean hasBootstrapOSImage() {
    return this.bootstrapOSImage != null;
  }
  
  public String getBootstrapProvisioningIP() {
    return this.bootstrapProvisioningIP;
  }
  
  public A withBootstrapProvisioningIP(String bootstrapProvisioningIP) {
    this.bootstrapProvisioningIP=bootstrapProvisioningIP; return (A) this;
  }
  
  public boolean hasBootstrapProvisioningIP() {
    return this.bootstrapProvisioningIP != null;
  }
  
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  
  public boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  
  public String getClusterProvisioningIP() {
    return this.clusterProvisioningIP;
  }
  
  public A withClusterProvisioningIP(String clusterProvisioningIP) {
    this.clusterProvisioningIP=clusterProvisioningIP; return (A) this;
  }
  
  public boolean hasClusterProvisioningIP() {
    return this.clusterProvisioningIP != null;
  }
  
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  
  public String getExternalBridge() {
    return this.externalBridge;
  }
  
  public A withExternalBridge(String externalBridge) {
    this.externalBridge=externalBridge; return (A) this;
  }
  
  public boolean hasExternalBridge() {
    return this.externalBridge != null;
  }
  
  public String getExternalMACAddress() {
    return this.externalMACAddress;
  }
  
  public A withExternalMACAddress(String externalMACAddress) {
    this.externalMACAddress=externalMACAddress; return (A) this;
  }
  
  public boolean hasExternalMACAddress() {
    return this.externalMACAddress != null;
  }
  
  public A addToHosts(int index,Host item) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    HostBuilder builder = new HostBuilder(item);
    if (index < 0 || index >= hosts.size()) { _visitables.get("hosts").add(builder); hosts.add(builder); } else { _visitables.get("hosts").add(index, builder); hosts.add(index, builder);}
    return (A)this;
  }
  
  public A setToHosts(int index,Host item) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    HostBuilder builder = new HostBuilder(item);
    if (index < 0 || index >= hosts.size()) { _visitables.get("hosts").add(builder); hosts.add(builder); } else { _visitables.get("hosts").set(index, builder); hosts.set(index, builder);}
    return (A)this;
  }
  
  public A addToHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(builder);this.hosts.add(builder);} return (A)this;
  }
  
  public A addAllToHosts(Collection<Host> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<HostBuilder>();}
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").add(builder);this.hosts.add(builder);} return (A)this;
  }
  
  public A removeFromHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... items) {
    if (this.hosts == null) return (A)this;
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").remove(builder); this.hosts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHosts(Collection<Host> items) {
    if (this.hosts == null) return (A)this;
    for (Host item : items) {HostBuilder builder = new HostBuilder(item);_visitables.get("hosts").remove(builder); this.hosts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHosts(Predicate<HostBuilder> predicate) {
    if (hosts == null) return (A) this;
    final Iterator<HostBuilder> each = hosts.iterator();
    final List visitables = _visitables.get("hosts");
    while (each.hasNext()) {
      HostBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Host> buildHosts() {
    return hosts != null ? build(hosts) : null;
  }
  
  public Host buildHost(int index) {
    return this.hosts.get(index).build();
  }
  
  public Host buildFirstHost() {
    return this.hosts.get(0).build();
  }
  
  public Host buildLastHost() {
    return this.hosts.get(hosts.size() - 1).build();
  }
  
  public Host buildMatchingHost(Predicate<HostBuilder> predicate) {
    for (HostBuilder item: hosts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingHost(Predicate<HostBuilder> predicate) {
    for (HostBuilder item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withHosts(List<Host> hosts) {
    if (this.hosts != null) { _visitables.get("hosts").clear();}
    if (hosts != null) {this.hosts = new ArrayList(); for (Host item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  
  public A withHosts(io.fabric8.openshift.api.model.installer.baremetal.v1.Host... hosts) {
    if (this.hosts != null) {this.hosts.clear(); _visitables.remove("hosts"); }
    if (hosts != null) {for (Host item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  
  public boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  
  public HostsNested<A> addNewHost() {
    return new HostsNested(-1, null);
  }
  
  public HostsNested<A> addNewHostLike(Host item) {
    return new HostsNested(-1, item);
  }
  
  public HostsNested<A> setNewHostLike(int index,Host item) {
    return new HostsNested(index, item);
  }
  
  public HostsNested<A> editHost(int index) {
    if (hosts.size() <= index) throw new RuntimeException("Can't edit hosts. Index exceeds size.");
    return setNewHostLike(index, buildHost(index));
  }
  
  public HostsNested<A> editFirstHost() {
    if (hosts.size() == 0) throw new RuntimeException("Can't edit first hosts. The list is empty.");
    return setNewHostLike(0, buildHost(0));
  }
  
  public HostsNested<A> editLastHost() {
    int index = hosts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last hosts. The list is empty.");
    return setNewHostLike(index, buildHost(index));
  }
  
  public HostsNested<A> editMatchingHost(Predicate<HostBuilder> predicate) {
    int index = -1;
    for (int i=0;i<hosts.size();i++) { 
    if (predicate.test(hosts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching hosts. No match found.");
    return setNewHostLike(index, buildHost(index));
  }
  
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP=ingressVIP; return (A) this;
  }
  
  public boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  
  public A addToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.add(index, item);
    return (A)this;
  }
  
  public A setToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.set(index, item); return (A)this;
  }
  
  public A addToIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  
  public A addAllToIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  
  public A removeFromIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  
  public List<String> getIngressVIPs() {
    return this.ingressVIPs;
  }
  
  public String getIngressVIP(int index) {
    return this.ingressVIPs.get(index);
  }
  
  public String getFirstIngressVIP() {
    return this.ingressVIPs.get(0);
  }
  
  public String getLastIngressVIP() {
    return this.ingressVIPs.get(ingressVIPs.size() - 1);
  }
  
  public String getMatchingIngressVIP(Predicate<String> predicate) {
    for (String item: ingressVIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
    for (String item: ingressVIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withIngressVIPs(List<String> ingressVIPs) {
    if (ingressVIPs != null) {this.ingressVIPs = new ArrayList(); for (String item : ingressVIPs){this.addToIngressVIPs(item);}} else { this.ingressVIPs = null;} return (A) this;
  }
  
  public A withIngressVIPs(java.lang.String... ingressVIPs) {
    if (this.ingressVIPs != null) {this.ingressVIPs.clear(); _visitables.remove("ingressVIPs"); }
    if (ingressVIPs != null) {for (String item :ingressVIPs){ this.addToIngressVIPs(item);}} return (A) this;
  }
  
  public boolean hasIngressVIPs() {
    return ingressVIPs != null && !ingressVIPs.isEmpty();
  }
  
  public String getLibvirtURI() {
    return this.libvirtURI;
  }
  
  public A withLibvirtURI(String libvirtURI) {
    this.libvirtURI=libvirtURI; return (A) this;
  }
  
  public boolean hasLibvirtURI() {
    return this.libvirtURI != null;
  }
  
  public BareMetalPlatformLoadBalancer getLoadBalancer() {
    return this.loadBalancer;
  }
  
  public A withLoadBalancer(BareMetalPlatformLoadBalancer loadBalancer) {
    this.loadBalancer=loadBalancer; return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public A withNewLoadBalancer(String type) {
    return (A)withLoadBalancer(new BareMetalPlatformLoadBalancer(type));
  }
  
  public String getProvisioningBridge() {
    return this.provisioningBridge;
  }
  
  public A withProvisioningBridge(String provisioningBridge) {
    this.provisioningBridge=provisioningBridge; return (A) this;
  }
  
  public boolean hasProvisioningBridge() {
    return this.provisioningBridge != null;
  }
  
  public Boolean getProvisioningDHCPExternal() {
    return this.provisioningDHCPExternal;
  }
  
  public A withProvisioningDHCPExternal(Boolean provisioningDHCPExternal) {
    this.provisioningDHCPExternal=provisioningDHCPExternal; return (A) this;
  }
  
  public boolean hasProvisioningDHCPExternal() {
    return this.provisioningDHCPExternal != null;
  }
  
  public String getProvisioningDHCPRange() {
    return this.provisioningDHCPRange;
  }
  
  public A withProvisioningDHCPRange(String provisioningDHCPRange) {
    this.provisioningDHCPRange=provisioningDHCPRange; return (A) this;
  }
  
  public boolean hasProvisioningDHCPRange() {
    return this.provisioningDHCPRange != null;
  }
  
  public String getProvisioningHostIP() {
    return this.provisioningHostIP;
  }
  
  public A withProvisioningHostIP(String provisioningHostIP) {
    this.provisioningHostIP=provisioningHostIP; return (A) this;
  }
  
  public boolean hasProvisioningHostIP() {
    return this.provisioningHostIP != null;
  }
  
  public String getProvisioningMACAddress() {
    return this.provisioningMACAddress;
  }
  
  public A withProvisioningMACAddress(String provisioningMACAddress) {
    this.provisioningMACAddress=provisioningMACAddress; return (A) this;
  }
  
  public boolean hasProvisioningMACAddress() {
    return this.provisioningMACAddress != null;
  }
  
  public String getProvisioningNetwork() {
    return this.provisioningNetwork;
  }
  
  public A withProvisioningNetwork(String provisioningNetwork) {
    this.provisioningNetwork=provisioningNetwork; return (A) this;
  }
  
  public boolean hasProvisioningNetwork() {
    return this.provisioningNetwork != null;
  }
  
  public String getProvisioningNetworkCIDR() {
    return this.provisioningNetworkCIDR;
  }
  
  public A withProvisioningNetworkCIDR(String provisioningNetworkCIDR) {
    this.provisioningNetworkCIDR=provisioningNetworkCIDR; return (A) this;
  }
  
  public boolean hasProvisioningNetworkCIDR() {
    return this.provisioningNetworkCIDR != null;
  }
  
  public String getProvisioningNetworkInterface() {
    return this.provisioningNetworkInterface;
  }
  
  public A withProvisioningNetworkInterface(String provisioningNetworkInterface) {
    this.provisioningNetworkInterface=provisioningNetworkInterface; return (A) this;
  }
  
  public boolean hasProvisioningNetworkInterface() {
    return this.provisioningNetworkInterface != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(apiVIP, that.apiVIP)) return false;
  
    if (!java.util.Objects.equals(apiVIPs, that.apiVIPs)) return false;
  
    if (!java.util.Objects.equals(bootstrapExternalStaticGateway, that.bootstrapExternalStaticGateway)) return false;
  
    if (!java.util.Objects.equals(bootstrapExternalStaticIP, that.bootstrapExternalStaticIP)) return false;
  
    if (!java.util.Objects.equals(bootstrapOSImage, that.bootstrapOSImage)) return false;
  
    if (!java.util.Objects.equals(bootstrapProvisioningIP, that.bootstrapProvisioningIP)) return false;
  
    if (!java.util.Objects.equals(clusterOSImage, that.clusterOSImage)) return false;
  
    if (!java.util.Objects.equals(clusterProvisioningIP, that.clusterProvisioningIP)) return false;
  
    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;
  
    if (!java.util.Objects.equals(externalBridge, that.externalBridge)) return false;
  
    if (!java.util.Objects.equals(externalMACAddress, that.externalMACAddress)) return false;
  
    if (!java.util.Objects.equals(hosts, that.hosts)) return false;
  
    if (!java.util.Objects.equals(ingressVIP, that.ingressVIP)) return false;
  
    if (!java.util.Objects.equals(ingressVIPs, that.ingressVIPs)) return false;
  
    if (!java.util.Objects.equals(libvirtURI, that.libvirtURI)) return false;
  
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
  
    if (!java.util.Objects.equals(provisioningBridge, that.provisioningBridge)) return false;
  
    if (!java.util.Objects.equals(provisioningDHCPExternal, that.provisioningDHCPExternal)) return false;
  
    if (!java.util.Objects.equals(provisioningDHCPRange, that.provisioningDHCPRange)) return false;
  
    if (!java.util.Objects.equals(provisioningHostIP, that.provisioningHostIP)) return false;
  
    if (!java.util.Objects.equals(provisioningMACAddress, that.provisioningMACAddress)) return false;
  
    if (!java.util.Objects.equals(provisioningNetwork, that.provisioningNetwork)) return false;
  
    if (!java.util.Objects.equals(provisioningNetworkCIDR, that.provisioningNetworkCIDR)) return false;
  
    if (!java.util.Objects.equals(provisioningNetworkInterface, that.provisioningNetworkInterface)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVIP,  apiVIPs,  bootstrapExternalStaticGateway,  bootstrapExternalStaticIP,  bootstrapOSImage,  bootstrapProvisioningIP,  clusterOSImage,  clusterProvisioningIP,  defaultMachinePlatform,  externalBridge,  externalMACAddress,  hosts,  ingressVIP,  ingressVIPs,  libvirtURI,  loadBalancer,  provisioningBridge,  provisioningDHCPExternal,  provisioningDHCPRange,  provisioningHostIP,  provisioningMACAddress,  provisioningNetwork,  provisioningNetworkCIDR,  provisioningNetworkInterface,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (apiVIPs != null && !apiVIPs.isEmpty()) { sb.append("apiVIPs:"); sb.append(apiVIPs + ","); }
    if (bootstrapExternalStaticGateway != null) { sb.append("bootstrapExternalStaticGateway:"); sb.append(bootstrapExternalStaticGateway + ","); }
    if (bootstrapExternalStaticIP != null) { sb.append("bootstrapExternalStaticIP:"); sb.append(bootstrapExternalStaticIP + ","); }
    if (bootstrapOSImage != null) { sb.append("bootstrapOSImage:"); sb.append(bootstrapOSImage + ","); }
    if (bootstrapProvisioningIP != null) { sb.append("bootstrapProvisioningIP:"); sb.append(bootstrapProvisioningIP + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (clusterProvisioningIP != null) { sb.append("clusterProvisioningIP:"); sb.append(clusterProvisioningIP + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (externalBridge != null) { sb.append("externalBridge:"); sb.append(externalBridge + ","); }
    if (externalMACAddress != null) { sb.append("externalMACAddress:"); sb.append(externalMACAddress + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (ingressVIPs != null && !ingressVIPs.isEmpty()) { sb.append("ingressVIPs:"); sb.append(ingressVIPs + ","); }
    if (libvirtURI != null) { sb.append("libvirtURI:"); sb.append(libvirtURI + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (provisioningBridge != null) { sb.append("provisioningBridge:"); sb.append(provisioningBridge + ","); }
    if (provisioningDHCPExternal != null) { sb.append("provisioningDHCPExternal:"); sb.append(provisioningDHCPExternal + ","); }
    if (provisioningDHCPRange != null) { sb.append("provisioningDHCPRange:"); sb.append(provisioningDHCPRange + ","); }
    if (provisioningHostIP != null) { sb.append("provisioningHostIP:"); sb.append(provisioningHostIP + ","); }
    if (provisioningMACAddress != null) { sb.append("provisioningMACAddress:"); sb.append(provisioningMACAddress + ","); }
    if (provisioningNetwork != null) { sb.append("provisioningNetwork:"); sb.append(provisioningNetwork + ","); }
    if (provisioningNetworkCIDR != null) { sb.append("provisioningNetworkCIDR:"); sb.append(provisioningNetworkCIDR + ","); }
    if (provisioningNetworkInterface != null) { sb.append("provisioningNetworkInterface:"); sb.append(provisioningNetworkInterface + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withProvisioningDHCPExternal() {
    return withProvisioningDHCPExternal(true);
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  
  }
  public class HostsNested<N> extends HostFluent<HostsNested<N>> implements Nested<N>{
    HostsNested(int index,Host item) {
      this.index = index;
      this.builder = new HostBuilder(this, item);
    }
    HostBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToHosts(index,builder.build());
    }
    
    public N endHost() {
      return and();
    }
    
  
  }

}