package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NetworkBuilder extends NetworkFluent<NetworkBuilder> implements VisitableBuilder<Network,NetworkBuilder>{
  public NetworkBuilder() {
    this(new Network());
  }
  
  public NetworkBuilder(NetworkFluent<?> fluent) {
    this(fluent, new Network());
  }
  
  public NetworkBuilder(NetworkFluent<?> fluent,Network instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NetworkBuilder(Network instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NetworkFluent<?> fluent;
  
  public Network build() {
    Network buildable = new Network(fluent.buildDnsmasqOptions(),fluent.getIf());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}