package io.fabric8.openshift.api.model.installer.libvirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkFluent<A extends NetworkFluent<A>> extends BaseFluent<A>{
  public NetworkFluent() {
  }
  
  public NetworkFluent(Network instance) {
    this.copyInstance(instance);
  }
  private ArrayList<DnsmasqOptionBuilder> dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();
  private String _if;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Network instance) {
    instance = (instance != null ? instance : new Network());
  
    if (instance != null) {
        this.withDnsmasqOptions(instance.getDnsmasqOptions());
        this.withIf(instance.getIf());
        this.withDnsmasqOptions(instance.getDnsmasqOptions());
        this.withIf(instance.getIf());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToDnsmasqOptions(int index,DnsmasqOption item) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
    if (index < 0 || index >= dnsmasqOptions.size()) { _visitables.get("dnsmasqOptions").add(builder); dnsmasqOptions.add(builder); } else { _visitables.get("dnsmasqOptions").add(index, builder); dnsmasqOptions.add(index, builder);}
    return (A)this;
  }
  
  public A setToDnsmasqOptions(int index,DnsmasqOption item) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);
    if (index < 0 || index >= dnsmasqOptions.size()) { _visitables.get("dnsmasqOptions").add(builder); dnsmasqOptions.add(builder); } else { _visitables.get("dnsmasqOptions").set(index, builder); dnsmasqOptions.set(index, builder);}
    return (A)this;
  }
  
  public A addToDnsmasqOptions(io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption... items) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").add(builder);this.dnsmasqOptions.add(builder);} return (A)this;
  }
  
  public A addAllToDnsmasqOptions(Collection<DnsmasqOption> items) {
    if (this.dnsmasqOptions == null) {this.dnsmasqOptions = new ArrayList<DnsmasqOptionBuilder>();}
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").add(builder);this.dnsmasqOptions.add(builder);} return (A)this;
  }
  
  public A removeFromDnsmasqOptions(io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption... items) {
    if (this.dnsmasqOptions == null) return (A)this;
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").remove(builder); this.dnsmasqOptions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDnsmasqOptions(Collection<DnsmasqOption> items) {
    if (this.dnsmasqOptions == null) return (A)this;
    for (DnsmasqOption item : items) {DnsmasqOptionBuilder builder = new DnsmasqOptionBuilder(item);_visitables.get("dnsmasqOptions").remove(builder); this.dnsmasqOptions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDnsmasqOptions(Predicate<DnsmasqOptionBuilder> predicate) {
    if (dnsmasqOptions == null) return (A) this;
    final Iterator<DnsmasqOptionBuilder> each = dnsmasqOptions.iterator();
    final List visitables = _visitables.get("dnsmasqOptions");
    while (each.hasNext()) {
      DnsmasqOptionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<DnsmasqOption> buildDnsmasqOptions() {
    return dnsmasqOptions != null ? build(dnsmasqOptions) : null;
  }
  
  public DnsmasqOption buildDnsmasqOption(int index) {
    return this.dnsmasqOptions.get(index).build();
  }
  
  public DnsmasqOption buildFirstDnsmasqOption() {
    return this.dnsmasqOptions.get(0).build();
  }
  
  public DnsmasqOption buildLastDnsmasqOption() {
    return this.dnsmasqOptions.get(dnsmasqOptions.size() - 1).build();
  }
  
  public DnsmasqOption buildMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
    for (DnsmasqOptionBuilder item: dnsmasqOptions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
    for (DnsmasqOptionBuilder item: dnsmasqOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withDnsmasqOptions(List<DnsmasqOption> dnsmasqOptions) {
    if (this.dnsmasqOptions != null) { _visitables.get("dnsmasqOptions").clear();}
    if (dnsmasqOptions != null) {this.dnsmasqOptions = new ArrayList(); for (DnsmasqOption item : dnsmasqOptions){this.addToDnsmasqOptions(item);}} else { this.dnsmasqOptions = null;} return (A) this;
  }
  
  public A withDnsmasqOptions(io.fabric8.openshift.api.model.installer.libvirt.v1.DnsmasqOption... dnsmasqOptions) {
    if (this.dnsmasqOptions != null) {this.dnsmasqOptions.clear(); _visitables.remove("dnsmasqOptions"); }
    if (dnsmasqOptions != null) {for (DnsmasqOption item :dnsmasqOptions){ this.addToDnsmasqOptions(item);}} return (A) this;
  }
  
  public boolean hasDnsmasqOptions() {
    return dnsmasqOptions != null && !dnsmasqOptions.isEmpty();
  }
  
  public A addNewDnsmasqOption(String name,String value) {
    return (A)addToDnsmasqOptions(new DnsmasqOption(name, value));
  }
  
  public DnsmasqOptionsNested<A> addNewDnsmasqOption() {
    return new DnsmasqOptionsNested(-1, null);
  }
  
  public DnsmasqOptionsNested<A> addNewDnsmasqOptionLike(DnsmasqOption item) {
    return new DnsmasqOptionsNested(-1, item);
  }
  
  public DnsmasqOptionsNested<A> setNewDnsmasqOptionLike(int index,DnsmasqOption item) {
    return new DnsmasqOptionsNested(index, item);
  }
  
  public DnsmasqOptionsNested<A> editDnsmasqOption(int index) {
    if (dnsmasqOptions.size() <= index) throw new RuntimeException("Can't edit dnsmasqOptions. Index exceeds size.");
    return setNewDnsmasqOptionLike(index, buildDnsmasqOption(index));
  }
  
  public DnsmasqOptionsNested<A> editFirstDnsmasqOption() {
    if (dnsmasqOptions.size() == 0) throw new RuntimeException("Can't edit first dnsmasqOptions. The list is empty.");
    return setNewDnsmasqOptionLike(0, buildDnsmasqOption(0));
  }
  
  public DnsmasqOptionsNested<A> editLastDnsmasqOption() {
    int index = dnsmasqOptions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dnsmasqOptions. The list is empty.");
    return setNewDnsmasqOptionLike(index, buildDnsmasqOption(index));
  }
  
  public DnsmasqOptionsNested<A> editMatchingDnsmasqOption(Predicate<DnsmasqOptionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dnsmasqOptions.size();i++) { 
    if (predicate.test(dnsmasqOptions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dnsmasqOptions. No match found.");
    return setNewDnsmasqOptionLike(index, buildDnsmasqOption(index));
  }
  
  public String getIf() {
    return this._if;
  }
  
  public A withIf(String _if) {
    this._if=_if; return (A) this;
  }
  
  public boolean hasIf() {
    return this._if != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkFluent that = (NetworkFluent) o;
    if (!java.util.Objects.equals(dnsmasqOptions, that.dnsmasqOptions)) return false;
  
    if (!java.util.Objects.equals(_if, that._if)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dnsmasqOptions,  _if,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsmasqOptions != null && !dnsmasqOptions.isEmpty()) { sb.append("dnsmasqOptions:"); sb.append(dnsmasqOptions + ","); }
    if (_if != null) { sb.append("_if:"); sb.append(_if + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DnsmasqOptionsNested<N> extends DnsmasqOptionFluent<DnsmasqOptionsNested<N>> implements Nested<N>{
    DnsmasqOptionsNested(int index,DnsmasqOption item) {
      this.index = index;
      this.builder = new DnsmasqOptionBuilder(this, item);
    }
    DnsmasqOptionBuilder builder;
    int index;
    
    public N and() {
      return (N) NetworkFluent.this.setToDnsmasqOptions(index,builder.build());
    }
    
    public N endDnsmasqOption() {
      return and();
    }
    
  
  }

}