package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.openshift.api.model.config.v1.NutanixPlatformLoadBalancer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  
  public PlatformFluent(Platform instance) {
    this.copyInstance(instance);
  }
  private String apiVIP;
  private List<String> apiVIPs = new ArrayList<String>();
  private String clusterOSImage;
  private MachinePoolBuilder defaultMachinePlatform;
  private String ingressVIP;
  private List<String> ingressVIPs = new ArrayList<String>();
  private NutanixPlatformLoadBalancer loadBalancer;
  private PrismCentralBuilder prismCentral;
  private ArrayList<PrismElementBuilder> prismElements = new ArrayList<PrismElementBuilder>();
  private List<String> subnetUUIDs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Platform instance) {
    instance = (instance != null ? instance : new Platform());
  
    if (instance != null) {
        this.withApiVIP(instance.getApiVIP());
        this.withApiVIPs(instance.getApiVIPs());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withIngressVIP(instance.getIngressVIP());
        this.withIngressVIPs(instance.getIngressVIPs());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withPrismCentral(instance.getPrismCentral());
        this.withPrismElements(instance.getPrismElements());
        this.withSubnetUUIDs(instance.getSubnetUUIDs());
        this.withApiVIP(instance.getApiVIP());
        this.withApiVIPs(instance.getApiVIPs());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withIngressVIP(instance.getIngressVIP());
        this.withIngressVIPs(instance.getIngressVIPs());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.withPrismCentral(instance.getPrismCentral());
        this.withPrismElements(instance.getPrismElements());
        this.withSubnetUUIDs(instance.getSubnetUUIDs());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getApiVIP() {
    return this.apiVIP;
  }
  
  public A withApiVIP(String apiVIP) {
    this.apiVIP=apiVIP; return (A) this;
  }
  
  public boolean hasApiVIP() {
    return this.apiVIP != null;
  }
  
  public A addToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.add(index, item);
    return (A)this;
  }
  
  public A setToApiVIPs(int index,String item) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    this.apiVIPs.set(index, item); return (A)this;
  }
  
  public A addToApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  
  public A addAllToApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) {this.apiVIPs = new ArrayList<String>();}
    for (String item : items) {this.apiVIPs.add(item);} return (A)this;
  }
  
  public A removeFromApiVIPs(java.lang.String... items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromApiVIPs(Collection<String> items) {
    if (this.apiVIPs == null) return (A)this;
    for (String item : items) { this.apiVIPs.remove(item);} return (A)this;
  }
  
  public List<String> getApiVIPs() {
    return this.apiVIPs;
  }
  
  public String getApiVIP(int index) {
    return this.apiVIPs.get(index);
  }
  
  public String getFirstApiVIP() {
    return this.apiVIPs.get(0);
  }
  
  public String getLastApiVIP() {
    return this.apiVIPs.get(apiVIPs.size() - 1);
  }
  
  public String getMatchingApiVIP(Predicate<String> predicate) {
    for (String item: apiVIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingApiVIP(Predicate<String> predicate) {
    for (String item: apiVIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withApiVIPs(List<String> apiVIPs) {
    if (apiVIPs != null) {this.apiVIPs = new ArrayList(); for (String item : apiVIPs){this.addToApiVIPs(item);}} else { this.apiVIPs = null;} return (A) this;
  }
  
  public A withApiVIPs(java.lang.String... apiVIPs) {
    if (this.apiVIPs != null) {this.apiVIPs.clear(); _visitables.remove("apiVIPs"); }
    if (apiVIPs != null) {for (String item :apiVIPs){ this.addToApiVIPs(item);}} return (A) this;
  }
  
  public boolean hasApiVIPs() {
    return apiVIPs != null && !apiVIPs.isEmpty();
  }
  
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage=clusterOSImage; return (A) this;
  }
  
  public boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform!=null ?this.defaultMachinePlatform.build():null;
  }
  
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform!=null){ this.defaultMachinePlatform= new MachinePoolBuilder(defaultMachinePlatform); _visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);} else { this.defaultMachinePlatform = null; _visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform); } return (A) this;
  }
  
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  
  public String getIngressVIP() {
    return this.ingressVIP;
  }
  
  public A withIngressVIP(String ingressVIP) {
    this.ingressVIP=ingressVIP; return (A) this;
  }
  
  public boolean hasIngressVIP() {
    return this.ingressVIP != null;
  }
  
  public A addToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.add(index, item);
    return (A)this;
  }
  
  public A setToIngressVIPs(int index,String item) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    this.ingressVIPs.set(index, item); return (A)this;
  }
  
  public A addToIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  
  public A addAllToIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) {this.ingressVIPs = new ArrayList<String>();}
    for (String item : items) {this.ingressVIPs.add(item);} return (A)this;
  }
  
  public A removeFromIngressVIPs(java.lang.String... items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  
  public A removeAllFromIngressVIPs(Collection<String> items) {
    if (this.ingressVIPs == null) return (A)this;
    for (String item : items) { this.ingressVIPs.remove(item);} return (A)this;
  }
  
  public List<String> getIngressVIPs() {
    return this.ingressVIPs;
  }
  
  public String getIngressVIP(int index) {
    return this.ingressVIPs.get(index);
  }
  
  public String getFirstIngressVIP() {
    return this.ingressVIPs.get(0);
  }
  
  public String getLastIngressVIP() {
    return this.ingressVIPs.get(ingressVIPs.size() - 1);
  }
  
  public String getMatchingIngressVIP(Predicate<String> predicate) {
    for (String item: ingressVIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingIngressVIP(Predicate<String> predicate) {
    for (String item: ingressVIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withIngressVIPs(List<String> ingressVIPs) {
    if (ingressVIPs != null) {this.ingressVIPs = new ArrayList(); for (String item : ingressVIPs){this.addToIngressVIPs(item);}} else { this.ingressVIPs = null;} return (A) this;
  }
  
  public A withIngressVIPs(java.lang.String... ingressVIPs) {
    if (this.ingressVIPs != null) {this.ingressVIPs.clear(); _visitables.remove("ingressVIPs"); }
    if (ingressVIPs != null) {for (String item :ingressVIPs){ this.addToIngressVIPs(item);}} return (A) this;
  }
  
  public boolean hasIngressVIPs() {
    return ingressVIPs != null && !ingressVIPs.isEmpty();
  }
  
  public NutanixPlatformLoadBalancer getLoadBalancer() {
    return this.loadBalancer;
  }
  
  public A withLoadBalancer(NutanixPlatformLoadBalancer loadBalancer) {
    this.loadBalancer=loadBalancer; return (A) this;
  }
  
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  
  public A withNewLoadBalancer(String type) {
    return (A)withLoadBalancer(new NutanixPlatformLoadBalancer(type));
  }
  
  public PrismCentral buildPrismCentral() {
    return this.prismCentral!=null ?this.prismCentral.build():null;
  }
  
  public A withPrismCentral(PrismCentral prismCentral) {
    _visitables.get("prismCentral").remove(this.prismCentral);
    if (prismCentral!=null){ this.prismCentral= new PrismCentralBuilder(prismCentral); _visitables.get("prismCentral").add(this.prismCentral);} else { this.prismCentral = null; _visitables.get("prismCentral").remove(this.prismCentral); } return (A) this;
  }
  
  public boolean hasPrismCentral() {
    return this.prismCentral != null;
  }
  
  public PrismCentralNested<A> withNewPrismCentral() {
    return new PrismCentralNested(null);
  }
  
  public PrismCentralNested<A> withNewPrismCentralLike(PrismCentral item) {
    return new PrismCentralNested(item);
  }
  
  public PrismCentralNested<A> editPrismCentral() {
    return withNewPrismCentralLike(java.util.Optional.ofNullable(buildPrismCentral()).orElse(null));
  }
  
  public PrismCentralNested<A> editOrNewPrismCentral() {
    return withNewPrismCentralLike(java.util.Optional.ofNullable(buildPrismCentral()).orElse(new PrismCentralBuilder().build()));
  }
  
  public PrismCentralNested<A> editOrNewPrismCentralLike(PrismCentral item) {
    return withNewPrismCentralLike(java.util.Optional.ofNullable(buildPrismCentral()).orElse(item));
  }
  
  public A addToPrismElements(int index,PrismElement item) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<PrismElementBuilder>();}
    PrismElementBuilder builder = new PrismElementBuilder(item);
    if (index < 0 || index >= prismElements.size()) { _visitables.get("prismElements").add(builder); prismElements.add(builder); } else { _visitables.get("prismElements").add(index, builder); prismElements.add(index, builder);}
    return (A)this;
  }
  
  public A setToPrismElements(int index,PrismElement item) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<PrismElementBuilder>();}
    PrismElementBuilder builder = new PrismElementBuilder(item);
    if (index < 0 || index >= prismElements.size()) { _visitables.get("prismElements").add(builder); prismElements.add(builder); } else { _visitables.get("prismElements").set(index, builder); prismElements.set(index, builder);}
    return (A)this;
  }
  
  public A addToPrismElements(io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElement... items) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<PrismElementBuilder>();}
    for (PrismElement item : items) {PrismElementBuilder builder = new PrismElementBuilder(item);_visitables.get("prismElements").add(builder);this.prismElements.add(builder);} return (A)this;
  }
  
  public A addAllToPrismElements(Collection<PrismElement> items) {
    if (this.prismElements == null) {this.prismElements = new ArrayList<PrismElementBuilder>();}
    for (PrismElement item : items) {PrismElementBuilder builder = new PrismElementBuilder(item);_visitables.get("prismElements").add(builder);this.prismElements.add(builder);} return (A)this;
  }
  
  public A removeFromPrismElements(io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElement... items) {
    if (this.prismElements == null) return (A)this;
    for (PrismElement item : items) {PrismElementBuilder builder = new PrismElementBuilder(item);_visitables.get("prismElements").remove(builder); this.prismElements.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPrismElements(Collection<PrismElement> items) {
    if (this.prismElements == null) return (A)this;
    for (PrismElement item : items) {PrismElementBuilder builder = new PrismElementBuilder(item);_visitables.get("prismElements").remove(builder); this.prismElements.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPrismElements(Predicate<PrismElementBuilder> predicate) {
    if (prismElements == null) return (A) this;
    final Iterator<PrismElementBuilder> each = prismElements.iterator();
    final List visitables = _visitables.get("prismElements");
    while (each.hasNext()) {
      PrismElementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PrismElement> buildPrismElements() {
    return prismElements != null ? build(prismElements) : null;
  }
  
  public PrismElement buildPrismElement(int index) {
    return this.prismElements.get(index).build();
  }
  
  public PrismElement buildFirstPrismElement() {
    return this.prismElements.get(0).build();
  }
  
  public PrismElement buildLastPrismElement() {
    return this.prismElements.get(prismElements.size() - 1).build();
  }
  
  public PrismElement buildMatchingPrismElement(Predicate<PrismElementBuilder> predicate) {
    for (PrismElementBuilder item: prismElements) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingPrismElement(Predicate<PrismElementBuilder> predicate) {
    for (PrismElementBuilder item: prismElements) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withPrismElements(List<PrismElement> prismElements) {
    if (this.prismElements != null) { _visitables.get("prismElements").clear();}
    if (prismElements != null) {this.prismElements = new ArrayList(); for (PrismElement item : prismElements){this.addToPrismElements(item);}} else { this.prismElements = null;} return (A) this;
  }
  
  public A withPrismElements(io.fabric8.openshift.api.model.installer.nutanix.v1.PrismElement... prismElements) {
    if (this.prismElements != null) {this.prismElements.clear(); _visitables.remove("prismElements"); }
    if (prismElements != null) {for (PrismElement item :prismElements){ this.addToPrismElements(item);}} return (A) this;
  }
  
  public boolean hasPrismElements() {
    return prismElements != null && !prismElements.isEmpty();
  }
  
  public PrismElementsNested<A> addNewPrismElement() {
    return new PrismElementsNested(-1, null);
  }
  
  public PrismElementsNested<A> addNewPrismElementLike(PrismElement item) {
    return new PrismElementsNested(-1, item);
  }
  
  public PrismElementsNested<A> setNewPrismElementLike(int index,PrismElement item) {
    return new PrismElementsNested(index, item);
  }
  
  public PrismElementsNested<A> editPrismElement(int index) {
    if (prismElements.size() <= index) throw new RuntimeException("Can't edit prismElements. Index exceeds size.");
    return setNewPrismElementLike(index, buildPrismElement(index));
  }
  
  public PrismElementsNested<A> editFirstPrismElement() {
    if (prismElements.size() == 0) throw new RuntimeException("Can't edit first prismElements. The list is empty.");
    return setNewPrismElementLike(0, buildPrismElement(0));
  }
  
  public PrismElementsNested<A> editLastPrismElement() {
    int index = prismElements.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last prismElements. The list is empty.");
    return setNewPrismElementLike(index, buildPrismElement(index));
  }
  
  public PrismElementsNested<A> editMatchingPrismElement(Predicate<PrismElementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<prismElements.size();i++) { 
    if (predicate.test(prismElements.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching prismElements. No match found.");
    return setNewPrismElementLike(index, buildPrismElement(index));
  }
  
  public A addToSubnetUUIDs(int index,String item) {
    if (this.subnetUUIDs == null) {this.subnetUUIDs = new ArrayList<String>();}
    this.subnetUUIDs.add(index, item);
    return (A)this;
  }
  
  public A setToSubnetUUIDs(int index,String item) {
    if (this.subnetUUIDs == null) {this.subnetUUIDs = new ArrayList<String>();}
    this.subnetUUIDs.set(index, item); return (A)this;
  }
  
  public A addToSubnetUUIDs(java.lang.String... items) {
    if (this.subnetUUIDs == null) {this.subnetUUIDs = new ArrayList<String>();}
    for (String item : items) {this.subnetUUIDs.add(item);} return (A)this;
  }
  
  public A addAllToSubnetUUIDs(Collection<String> items) {
    if (this.subnetUUIDs == null) {this.subnetUUIDs = new ArrayList<String>();}
    for (String item : items) {this.subnetUUIDs.add(item);} return (A)this;
  }
  
  public A removeFromSubnetUUIDs(java.lang.String... items) {
    if (this.subnetUUIDs == null) return (A)this;
    for (String item : items) { this.subnetUUIDs.remove(item);} return (A)this;
  }
  
  public A removeAllFromSubnetUUIDs(Collection<String> items) {
    if (this.subnetUUIDs == null) return (A)this;
    for (String item : items) { this.subnetUUIDs.remove(item);} return (A)this;
  }
  
  public List<String> getSubnetUUIDs() {
    return this.subnetUUIDs;
  }
  
  public String getSubnetUUID(int index) {
    return this.subnetUUIDs.get(index);
  }
  
  public String getFirstSubnetUUID() {
    return this.subnetUUIDs.get(0);
  }
  
  public String getLastSubnetUUID() {
    return this.subnetUUIDs.get(subnetUUIDs.size() - 1);
  }
  
  public String getMatchingSubnetUUID(Predicate<String> predicate) {
    for (String item: subnetUUIDs) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingSubnetUUID(Predicate<String> predicate) {
    for (String item: subnetUUIDs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSubnetUUIDs(List<String> subnetUUIDs) {
    if (subnetUUIDs != null) {this.subnetUUIDs = new ArrayList(); for (String item : subnetUUIDs){this.addToSubnetUUIDs(item);}} else { this.subnetUUIDs = null;} return (A) this;
  }
  
  public A withSubnetUUIDs(java.lang.String... subnetUUIDs) {
    if (this.subnetUUIDs != null) {this.subnetUUIDs.clear(); _visitables.remove("subnetUUIDs"); }
    if (subnetUUIDs != null) {for (String item :subnetUUIDs){ this.addToSubnetUUIDs(item);}} return (A) this;
  }
  
  public boolean hasSubnetUUIDs() {
    return subnetUUIDs != null && !subnetUUIDs.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(apiVIP, that.apiVIP)) return false;
  
    if (!java.util.Objects.equals(apiVIPs, that.apiVIPs)) return false;
  
    if (!java.util.Objects.equals(clusterOSImage, that.clusterOSImage)) return false;
  
    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;
  
    if (!java.util.Objects.equals(ingressVIP, that.ingressVIP)) return false;
  
    if (!java.util.Objects.equals(ingressVIPs, that.ingressVIPs)) return false;
  
    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;
  
    if (!java.util.Objects.equals(prismCentral, that.prismCentral)) return false;
  
    if (!java.util.Objects.equals(prismElements, that.prismElements)) return false;
  
    if (!java.util.Objects.equals(subnetUUIDs, that.subnetUUIDs)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVIP,  apiVIPs,  clusterOSImage,  defaultMachinePlatform,  ingressVIP,  ingressVIPs,  loadBalancer,  prismCentral,  prismElements,  subnetUUIDs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVIP != null) { sb.append("apiVIP:"); sb.append(apiVIP + ","); }
    if (apiVIPs != null && !apiVIPs.isEmpty()) { sb.append("apiVIPs:"); sb.append(apiVIPs + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (ingressVIP != null) { sb.append("ingressVIP:"); sb.append(ingressVIP + ","); }
    if (ingressVIPs != null && !ingressVIPs.isEmpty()) { sb.append("ingressVIPs:"); sb.append(ingressVIPs + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (prismCentral != null) { sb.append("prismCentral:"); sb.append(prismCentral + ","); }
    if (prismElements != null && !prismElements.isEmpty()) { sb.append("prismElements:"); sb.append(prismElements + ","); }
    if (subnetUUIDs != null && !subnetUUIDs.isEmpty()) { sb.append("subnetUUIDs:"); sb.append(subnetUUIDs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  
  }
  public class PrismCentralNested<N> extends PrismCentralFluent<PrismCentralNested<N>> implements Nested<N>{
    PrismCentralNested(PrismCentral item) {
      this.builder = new PrismCentralBuilder(this, item);
    }
    PrismCentralBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withPrismCentral(builder.build());
    }
    
    public N endPrismCentral() {
      return and();
    }
    
  
  }
  public class PrismElementsNested<N> extends PrismElementFluent<PrismElementsNested<N>> implements Nested<N>{
    PrismElementsNested(int index,PrismElement item) {
      this.index = index;
      this.builder = new PrismElementBuilder(this, item);
    }
    PrismElementBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToPrismElements(index,builder.build());
    }
    
    public N endPrismElement() {
      return and();
    }
    
  
  }

}