package io.fabric8.openshift.api.model.installer.nutanix.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PrismCentralFluent<A extends PrismCentralFluent<A>> extends BaseFluent<A>{
  public PrismCentralFluent() {
  }
  
  public PrismCentralFluent(PrismCentral instance) {
    this.copyInstance(instance);
  }
  private PrismEndpointBuilder endpoint;
  private String password;
  private String username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PrismCentral instance) {
    instance = (instance != null ? instance : new PrismCentral());
  
    if (instance != null) {
        this.withEndpoint(instance.getEndpoint());
        this.withPassword(instance.getPassword());
        this.withUsername(instance.getUsername());
        this.withEndpoint(instance.getEndpoint());
        this.withPassword(instance.getPassword());
        this.withUsername(instance.getUsername());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public PrismEndpoint buildEndpoint() {
    return this.endpoint!=null ?this.endpoint.build():null;
  }
  
  public A withEndpoint(PrismEndpoint endpoint) {
    _visitables.get("endpoint").remove(this.endpoint);
    if (endpoint!=null){ this.endpoint= new PrismEndpointBuilder(endpoint); _visitables.get("endpoint").add(this.endpoint);} else { this.endpoint = null; _visitables.get("endpoint").remove(this.endpoint); } return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public A withNewEndpoint(String address,Integer port) {
    return (A)withEndpoint(new PrismEndpoint(address, port));
  }
  
  public EndpointNested<A> withNewEndpoint() {
    return new EndpointNested(null);
  }
  
  public EndpointNested<A> withNewEndpointLike(PrismEndpoint item) {
    return new EndpointNested(item);
  }
  
  public EndpointNested<A> editEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(null));
  }
  
  public EndpointNested<A> editOrNewEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(new PrismEndpointBuilder().build()));
  }
  
  public EndpointNested<A> editOrNewEndpointLike(PrismEndpoint item) {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(item));
  }
  
  public String getPassword() {
    return this.password;
  }
  
  public A withPassword(String password) {
    this.password=password; return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrismCentralFluent that = (PrismCentralFluent) o;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
  
    if (!java.util.Objects.equals(password, that.password)) return false;
  
    if (!java.util.Objects.equals(username, that.username)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(endpoint,  password,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EndpointNested<N> extends PrismEndpointFluent<EndpointNested<N>> implements Nested<N>{
    EndpointNested(PrismEndpoint item) {
      this.builder = new PrismEndpointBuilder(this, item);
    }
    PrismEndpointBuilder builder;
    
    public N and() {
      return (N) PrismCentralFluent.this.withEndpoint(builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }

}