package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NamedPortTargetFluent<A extends NamedPortTargetFluent<A>> extends BaseFluent<A>{
  public NamedPortTargetFluent() {
  }
  
  public NamedPortTargetFluent(NamedPortTarget instance) {
    this.copyInstance(instance);
  }
  private ArrayList<FixedIPBuilder> fixedIPs = new ArrayList<FixedIPBuilder>();
  private String id;
  private NetworkFilterBuilder network;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NamedPortTarget instance) {
    instance = (instance != null ? instance : new NamedPortTarget());
  
    if (instance != null) {
        this.withFixedIPs(instance.getFixedIPs());
        this.withId(instance.getId());
        this.withNetwork(instance.getNetwork());
        this.withFixedIPs(instance.getFixedIPs());
        this.withId(instance.getId());
        this.withNetwork(instance.getNetwork());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToFixedIPs(int index,FixedIP item) {
    if (this.fixedIPs == null) {this.fixedIPs = new ArrayList<FixedIPBuilder>();}
    FixedIPBuilder builder = new FixedIPBuilder(item);
    if (index < 0 || index >= fixedIPs.size()) { _visitables.get("fixedIPs").add(builder); fixedIPs.add(builder); } else { _visitables.get("fixedIPs").add(index, builder); fixedIPs.add(index, builder);}
    return (A)this;
  }
  
  public A setToFixedIPs(int index,FixedIP item) {
    if (this.fixedIPs == null) {this.fixedIPs = new ArrayList<FixedIPBuilder>();}
    FixedIPBuilder builder = new FixedIPBuilder(item);
    if (index < 0 || index >= fixedIPs.size()) { _visitables.get("fixedIPs").add(builder); fixedIPs.add(builder); } else { _visitables.get("fixedIPs").set(index, builder); fixedIPs.set(index, builder);}
    return (A)this;
  }
  
  public A addToFixedIPs(io.fabric8.openshift.api.model.installer.openstack.v1.FixedIP... items) {
    if (this.fixedIPs == null) {this.fixedIPs = new ArrayList<FixedIPBuilder>();}
    for (FixedIP item : items) {FixedIPBuilder builder = new FixedIPBuilder(item);_visitables.get("fixedIPs").add(builder);this.fixedIPs.add(builder);} return (A)this;
  }
  
  public A addAllToFixedIPs(Collection<FixedIP> items) {
    if (this.fixedIPs == null) {this.fixedIPs = new ArrayList<FixedIPBuilder>();}
    for (FixedIP item : items) {FixedIPBuilder builder = new FixedIPBuilder(item);_visitables.get("fixedIPs").add(builder);this.fixedIPs.add(builder);} return (A)this;
  }
  
  public A removeFromFixedIPs(io.fabric8.openshift.api.model.installer.openstack.v1.FixedIP... items) {
    if (this.fixedIPs == null) return (A)this;
    for (FixedIP item : items) {FixedIPBuilder builder = new FixedIPBuilder(item);_visitables.get("fixedIPs").remove(builder); this.fixedIPs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFixedIPs(Collection<FixedIP> items) {
    if (this.fixedIPs == null) return (A)this;
    for (FixedIP item : items) {FixedIPBuilder builder = new FixedIPBuilder(item);_visitables.get("fixedIPs").remove(builder); this.fixedIPs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFixedIPs(Predicate<FixedIPBuilder> predicate) {
    if (fixedIPs == null) return (A) this;
    final Iterator<FixedIPBuilder> each = fixedIPs.iterator();
    final List visitables = _visitables.get("fixedIPs");
    while (each.hasNext()) {
      FixedIPBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FixedIP> buildFixedIPs() {
    return fixedIPs != null ? build(fixedIPs) : null;
  }
  
  public FixedIP buildFixedIP(int index) {
    return this.fixedIPs.get(index).build();
  }
  
  public FixedIP buildFirstFixedIP() {
    return this.fixedIPs.get(0).build();
  }
  
  public FixedIP buildLastFixedIP() {
    return this.fixedIPs.get(fixedIPs.size() - 1).build();
  }
  
  public FixedIP buildMatchingFixedIP(Predicate<FixedIPBuilder> predicate) {
    for (FixedIPBuilder item: fixedIPs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingFixedIP(Predicate<FixedIPBuilder> predicate) {
    for (FixedIPBuilder item: fixedIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withFixedIPs(List<FixedIP> fixedIPs) {
    if (this.fixedIPs != null) { _visitables.get("fixedIPs").clear();}
    if (fixedIPs != null) {this.fixedIPs = new ArrayList(); for (FixedIP item : fixedIPs){this.addToFixedIPs(item);}} else { this.fixedIPs = null;} return (A) this;
  }
  
  public A withFixedIPs(io.fabric8.openshift.api.model.installer.openstack.v1.FixedIP... fixedIPs) {
    if (this.fixedIPs != null) {this.fixedIPs.clear(); _visitables.remove("fixedIPs"); }
    if (fixedIPs != null) {for (FixedIP item :fixedIPs){ this.addToFixedIPs(item);}} return (A) this;
  }
  
  public boolean hasFixedIPs() {
    return fixedIPs != null && !fixedIPs.isEmpty();
  }
  
  public FixedIPsNested<A> addNewFixedIP() {
    return new FixedIPsNested(-1, null);
  }
  
  public FixedIPsNested<A> addNewFixedIPLike(FixedIP item) {
    return new FixedIPsNested(-1, item);
  }
  
  public FixedIPsNested<A> setNewFixedIPLike(int index,FixedIP item) {
    return new FixedIPsNested(index, item);
  }
  
  public FixedIPsNested<A> editFixedIP(int index) {
    if (fixedIPs.size() <= index) throw new RuntimeException("Can't edit fixedIPs. Index exceeds size.");
    return setNewFixedIPLike(index, buildFixedIP(index));
  }
  
  public FixedIPsNested<A> editFirstFixedIP() {
    if (fixedIPs.size() == 0) throw new RuntimeException("Can't edit first fixedIPs. The list is empty.");
    return setNewFixedIPLike(0, buildFixedIP(0));
  }
  
  public FixedIPsNested<A> editLastFixedIP() {
    int index = fixedIPs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fixedIPs. The list is empty.");
    return setNewFixedIPLike(index, buildFixedIP(index));
  }
  
  public FixedIPsNested<A> editMatchingFixedIP(Predicate<FixedIPBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fixedIPs.size();i++) { 
    if (predicate.test(fixedIPs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fixedIPs. No match found.");
    return setNewFixedIPLike(index, buildFixedIP(index));
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id=id; return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public NetworkFilter buildNetwork() {
    return this.network!=null ?this.network.build():null;
  }
  
  public A withNetwork(NetworkFilter network) {
    _visitables.get("network").remove(this.network);
    if (network!=null){ this.network= new NetworkFilterBuilder(network); _visitables.get("network").add(this.network);} else { this.network = null; _visitables.get("network").remove(this.network); } return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public A withNewNetwork(String id,String name) {
    return (A)withNetwork(new NetworkFilter(id, name));
  }
  
  public NetworkNested<A> withNewNetwork() {
    return new NetworkNested(null);
  }
  
  public NetworkNested<A> withNewNetworkLike(NetworkFilter item) {
    return new NetworkNested(item);
  }
  
  public NetworkNested<A> editNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(null));
  }
  
  public NetworkNested<A> editOrNewNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(new NetworkFilterBuilder().build()));
  }
  
  public NetworkNested<A> editOrNewNetworkLike(NetworkFilter item) {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NamedPortTargetFluent that = (NamedPortTargetFluent) o;
    if (!java.util.Objects.equals(fixedIPs, that.fixedIPs)) return false;
  
    if (!java.util.Objects.equals(id, that.id)) return false;
  
    if (!java.util.Objects.equals(network, that.network)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(fixedIPs,  id,  network,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fixedIPs != null && !fixedIPs.isEmpty()) { sb.append("fixedIPs:"); sb.append(fixedIPs + ","); }
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FixedIPsNested<N> extends FixedIPFluent<FixedIPsNested<N>> implements Nested<N>{
    FixedIPsNested(int index,FixedIP item) {
      this.index = index;
      this.builder = new FixedIPBuilder(this, item);
    }
    FixedIPBuilder builder;
    int index;
    
    public N and() {
      return (N) NamedPortTargetFluent.this.setToFixedIPs(index,builder.build());
    }
    
    public N endFixedIP() {
      return and();
    }
    
  
  }
  public class NetworkNested<N> extends NetworkFilterFluent<NetworkNested<N>> implements Nested<N>{
    NetworkNested(NetworkFilter item) {
      this.builder = new NetworkFilterBuilder(this, item);
    }
    NetworkFilterBuilder builder;
    
    public N and() {
      return (N) NamedPortTargetFluent.this.withNetwork(builder.build());
    }
    
    public N endNetwork() {
      return and();
    }
    
  
  }

}