package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachinePoolPlatformBuilder extends MachinePoolPlatformFluent<MachinePoolPlatformBuilder> implements VisitableBuilder<MachinePoolPlatform,MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(new MachinePoolPlatform());
  }
  
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent) {
    this(fluent, new MachinePoolPlatform());
  }
  
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachinePoolPlatformFluent<?> fluent;
  
  public MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.buildAlibabacloud(),fluent.buildAws(),fluent.buildAzure(),fluent.buildBaremetal(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildLibvirt(),fluent.buildNutanix(),fluent.buildOpenstack(),fluent.buildOvirt(),fluent.buildPowervs(),fluent.buildVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}