package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TopologyBuilder extends TopologyFluent<TopologyBuilder> implements VisitableBuilder<Topology,TopologyBuilder>{
  public TopologyBuilder() {
    this(new Topology());
  }
  
  public TopologyBuilder(TopologyFluent<?> fluent) {
    this(fluent, new Topology());
  }
  
  public TopologyBuilder(TopologyFluent<?> fluent,Topology instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TopologyBuilder(Topology instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TopologyFluent<?> fluent;
  
  public Topology build() {
    Topology buildable = new Topology(fluent.getComputeCluster(),fluent.getDatacenter(),fluent.getDatastore(),fluent.getFolder(),fluent.getNetworks(),fluent.getResourcePool());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}