package io.fabric8.openshift.api.model.installer.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private String amiID;
  private String iamRole;
  private EC2MetadataBuilder metadataService;
  private EC2RootVolumeBuilder rootVolume;
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withAmiID(instance.getAmiID());
          this.withIamRole(instance.getIamRole());
          this.withMetadataService(instance.getMetadataService());
          this.withRootVolume(instance.getRootVolume());
          this.withType(instance.getType());
          this.withZones(instance.getZones());
          this.withAmiID(instance.getAmiID());
          this.withIamRole(instance.getIamRole());
          this.withMetadataService(instance.getMetadataService());
          this.withRootVolume(instance.getRootVolume());
          this.withType(instance.getType());
          this.withZones(instance.getZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAmiID() {
    return this.amiID;
  }
  
  public A withAmiID(String amiID) {
    this.amiID = amiID;
    return (A) this;
  }
  
  public boolean hasAmiID() {
    return this.amiID != null;
  }
  
  public String getIamRole() {
    return this.iamRole;
  }
  
  public A withIamRole(String iamRole) {
    this.iamRole = iamRole;
    return (A) this;
  }
  
  public boolean hasIamRole() {
    return this.iamRole != null;
  }
  
  public EC2Metadata buildMetadataService() {
    return this.metadataService != null ? this.metadataService.build() : null;
  }
  
  public A withMetadataService(EC2Metadata metadataService) {
    this._visitables.remove(this.metadataService);
    if (metadataService != null) {
        this.metadataService = new EC2MetadataBuilder(metadataService);
        this._visitables.get("metadataService").add(this.metadataService);
    } else {
        this.metadataService = null;
        this._visitables.get("metadataService").remove(this.metadataService);
    }
    return (A) this;
  }
  
  public boolean hasMetadataService() {
    return this.metadataService != null;
  }
  
  public A withNewMetadataService(String authentication) {
    return (A)withMetadataService(new EC2Metadata(authentication));
  }
  
  public MetadataServiceNested<A> withNewMetadataService() {
    return new MetadataServiceNested(null);
  }
  
  public MetadataServiceNested<A> withNewMetadataServiceLike(EC2Metadata item) {
    return new MetadataServiceNested(item);
  }
  
  public MetadataServiceNested<A> editMetadataService() {
    return withNewMetadataServiceLike(java.util.Optional.ofNullable(buildMetadataService()).orElse(null));
  }
  
  public MetadataServiceNested<A> editOrNewMetadataService() {
    return withNewMetadataServiceLike(java.util.Optional.ofNullable(buildMetadataService()).orElse(new EC2MetadataBuilder().build()));
  }
  
  public MetadataServiceNested<A> editOrNewMetadataServiceLike(EC2Metadata item) {
    return withNewMetadataServiceLike(java.util.Optional.ofNullable(buildMetadataService()).orElse(item));
  }
  
  public EC2RootVolume buildRootVolume() {
    return this.rootVolume != null ? this.rootVolume.build() : null;
  }
  
  public A withRootVolume(EC2RootVolume rootVolume) {
    this._visitables.remove(this.rootVolume);
    if (rootVolume != null) {
        this.rootVolume = new EC2RootVolumeBuilder(rootVolume);
        this._visitables.get("rootVolume").add(this.rootVolume);
    } else {
        this.rootVolume = null;
        this._visitables.get("rootVolume").remove(this.rootVolume);
    }
    return (A) this;
  }
  
  public boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  
  public A withNewRootVolume(Integer iops,String kmsKeyARN,Integer size,String type) {
    return (A)withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
  }
  
  public RootVolumeNested<A> withNewRootVolume() {
    return new RootVolumeNested(null);
  }
  
  public RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
    return new RootVolumeNested(item);
  }
  
  public RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(null));
  }
  
  public RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(new EC2RootVolumeBuilder().build()));
  }
  
  public RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public List<String> getZones() {
    return this.zones;
  }
  
  public String getZone(int index) {
    return this.zones.get(index);
  }
  
  public String getFirstZone() {
    return this.zones.get(0);
  }
  
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  
  public String getMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withZones(List<String> zones) {
    if (zones != null) {
        this.zones = new ArrayList();
        for (String item : zones) {
          this.addToZones(item);
        }
    } else {
      this.zones = null;
    }
    return (A) this;
  }
  
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear(); _visitables.remove("zones"); }
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  
  public boolean hasZones() {
    return this.zones != null && !this.zones.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(amiID, that.amiID)) return false;
    if (!java.util.Objects.equals(iamRole, that.iamRole)) return false;
    if (!java.util.Objects.equals(metadataService, that.metadataService)) return false;
    if (!java.util.Objects.equals(rootVolume, that.rootVolume)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(zones, that.zones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(amiID,  iamRole,  metadataService,  rootVolume,  type,  zones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (amiID != null) { sb.append("amiID:"); sb.append(amiID + ","); }
    if (iamRole != null) { sb.append("iamRole:"); sb.append(iamRole + ","); }
    if (metadataService != null) { sb.append("metadataService:"); sb.append(metadataService + ","); }
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataServiceNested<N> extends EC2MetadataFluent<MetadataServiceNested<N>> implements Nested<N>{
    MetadataServiceNested(EC2Metadata item) {
      this.builder = new EC2MetadataBuilder(this, item);
    }
    EC2MetadataBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withMetadataService(builder.build());
    }
    
    public N endMetadataService() {
      return and();
    }
    
  
  }
  public class RootVolumeNested<N> extends EC2RootVolumeFluent<RootVolumeNested<N>> implements Nested<N>{
    RootVolumeNested(EC2RootVolume item) {
      this.builder = new EC2RootVolumeBuilder(this, item);
    }
    EC2RootVolumeBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withRootVolume(builder.build());
    }
    
    public N endRootVolume() {
      return and();
    }
    
  
  }

}