package io.fabric8.openshift.api.model.installer.nutanix.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifier;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.openshift.api.model.machine.v1.NutanixCategory;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private String bootType;
  private List<NutanixCategory> categories = new ArrayList<NutanixCategory>();
  private Long coresPerSocket;
  private Long cpus;
  private Long memoryMiB;
  private OSDiskBuilder osDisk;
  private NutanixResourceIdentifier project;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withBootType(instance.getBootType());
          this.withCategories(instance.getCategories());
          this.withCoresPerSocket(instance.getCoresPerSocket());
          this.withCpus(instance.getCpus());
          this.withMemoryMiB(instance.getMemoryMiB());
          this.withOsDisk(instance.getOsDisk());
          this.withProject(instance.getProject());
          this.withBootType(instance.getBootType());
          this.withCategories(instance.getCategories());
          this.withCoresPerSocket(instance.getCoresPerSocket());
          this.withCpus(instance.getCpus());
          this.withMemoryMiB(instance.getMemoryMiB());
          this.withOsDisk(instance.getOsDisk());
          this.withProject(instance.getProject());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBootType() {
    return this.bootType;
  }
  
  public A withBootType(String bootType) {
    this.bootType = bootType;
    return (A) this;
  }
  
  public boolean hasBootType() {
    return this.bootType != null;
  }
  
  public A addToCategories(int index,NutanixCategory item) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    this.categories.add(index, item);
    return (A)this;
  }
  
  public A setToCategories(int index,NutanixCategory item) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    this.categories.set(index, item); return (A)this;
  }
  
  public A addToCategories(io.fabric8.openshift.api.model.machine.v1.NutanixCategory... items) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    for (NutanixCategory item : items) {this.categories.add(item);} return (A)this;
  }
  
  public A addAllToCategories(Collection<NutanixCategory> items) {
    if (this.categories == null) {this.categories = new ArrayList<NutanixCategory>();}
    for (NutanixCategory item : items) {this.categories.add(item);} return (A)this;
  }
  
  public A removeFromCategories(io.fabric8.openshift.api.model.machine.v1.NutanixCategory... items) {
    if (this.categories == null) return (A)this;
    for (NutanixCategory item : items) { this.categories.remove(item);} return (A)this;
  }
  
  public A removeAllFromCategories(Collection<NutanixCategory> items) {
    if (this.categories == null) return (A)this;
    for (NutanixCategory item : items) { this.categories.remove(item);} return (A)this;
  }
  
  public List<NutanixCategory> getCategories() {
    return this.categories;
  }
  
  public NutanixCategory getCategory(int index) {
    return this.categories.get(index);
  }
  
  public NutanixCategory getFirstCategory() {
    return this.categories.get(0);
  }
  
  public NutanixCategory getLastCategory() {
    return this.categories.get(categories.size() - 1);
  }
  
  public NutanixCategory getMatchingCategory(Predicate<NutanixCategory> predicate) {
      for (NutanixCategory item : categories) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCategory(Predicate<NutanixCategory> predicate) {
      for (NutanixCategory item : categories) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCategories(List<NutanixCategory> categories) {
    if (categories != null) {
        this.categories = new ArrayList();
        for (NutanixCategory item : categories) {
          this.addToCategories(item);
        }
    } else {
      this.categories = null;
    }
    return (A) this;
  }
  
  public A withCategories(io.fabric8.openshift.api.model.machine.v1.NutanixCategory... categories) {
    if (this.categories != null) {this.categories.clear(); _visitables.remove("categories"); }
    if (categories != null) {for (NutanixCategory item :categories){ this.addToCategories(item);}} return (A) this;
  }
  
  public boolean hasCategories() {
    return this.categories != null && !this.categories.isEmpty();
  }
  
  public A addNewCategory(String key,String value) {
    return (A)addToCategories(new NutanixCategory(key, value));
  }
  
  public Long getCoresPerSocket() {
    return this.coresPerSocket;
  }
  
  public A withCoresPerSocket(Long coresPerSocket) {
    this.coresPerSocket = coresPerSocket;
    return (A) this;
  }
  
  public boolean hasCoresPerSocket() {
    return this.coresPerSocket != null;
  }
  
  public Long getCpus() {
    return this.cpus;
  }
  
  public A withCpus(Long cpus) {
    this.cpus = cpus;
    return (A) this;
  }
  
  public boolean hasCpus() {
    return this.cpus != null;
  }
  
  public Long getMemoryMiB() {
    return this.memoryMiB;
  }
  
  public A withMemoryMiB(Long memoryMiB) {
    this.memoryMiB = memoryMiB;
    return (A) this;
  }
  
  public boolean hasMemoryMiB() {
    return this.memoryMiB != null;
  }
  
  public OSDisk buildOsDisk() {
    return this.osDisk != null ? this.osDisk.build() : null;
  }
  
  public A withOsDisk(OSDisk osDisk) {
    this._visitables.remove(this.osDisk);
    if (osDisk != null) {
        this.osDisk = new OSDiskBuilder(osDisk);
        this._visitables.get("osDisk").add(this.osDisk);
    } else {
        this.osDisk = null;
        this._visitables.get("osDisk").remove(this.osDisk);
    }
    return (A) this;
  }
  
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  
  public A withNewOsDisk(Long diskSizeGiB) {
    return (A)withOsDisk(new OSDisk(diskSizeGiB));
  }
  
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  
  public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new OsDiskNested(item);
  }
  
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new OSDiskBuilder().build()));
  }
  
  public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  
  public NutanixResourceIdentifier getProject() {
    return this.project;
  }
  
  public A withProject(NutanixResourceIdentifier project) {
    this.project = project;
    return (A) this;
  }
  
  public boolean hasProject() {
    return this.project != null;
  }
  
  public A withNewProject(String name,String type,String uuid) {
    return (A)withProject(new NutanixResourceIdentifier(name, type, uuid));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(bootType, that.bootType)) return false;
    if (!java.util.Objects.equals(categories, that.categories)) return false;
    if (!java.util.Objects.equals(coresPerSocket, that.coresPerSocket)) return false;
    if (!java.util.Objects.equals(cpus, that.cpus)) return false;
    if (!java.util.Objects.equals(memoryMiB, that.memoryMiB)) return false;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;
    if (!java.util.Objects.equals(project, that.project)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bootType,  categories,  coresPerSocket,  cpus,  memoryMiB,  osDisk,  project,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bootType != null) { sb.append("bootType:"); sb.append(bootType + ","); }
    if (categories != null && !categories.isEmpty()) { sb.append("categories:"); sb.append(categories + ","); }
    if (coresPerSocket != null) { sb.append("coresPerSocket:"); sb.append(coresPerSocket + ","); }
    if (cpus != null) { sb.append("cpus:"); sb.append(cpus + ","); }
    if (memoryMiB != null) { sb.append("memoryMiB:"); sb.append(memoryMiB + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OsDiskNested<N> extends OSDiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OSDiskBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withOsDisk(builder.build());
    }
    
    public N endOsDisk() {
      return and();
    }
    
  
  }

}