package io.fabric8.openshift.api.model.installer.nutanix.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PrismElementFluent<A extends PrismElementFluent<A>> extends BaseFluent<A>{
  public PrismElementFluent() {
  }
  
  public PrismElementFluent(PrismElement instance) {
    this.copyInstance(instance);
  }
  private PrismEndpointBuilder endpoint;
  private String name;
  private String uuid;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PrismElement instance) {
    instance = (instance != null ? instance : new PrismElement());
    if (instance != null) {
          this.withEndpoint(instance.getEndpoint());
          this.withName(instance.getName());
          this.withUuid(instance.getUuid());
          this.withEndpoint(instance.getEndpoint());
          this.withName(instance.getName());
          this.withUuid(instance.getUuid());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PrismEndpoint buildEndpoint() {
    return this.endpoint != null ? this.endpoint.build() : null;
  }
  
  public A withEndpoint(PrismEndpoint endpoint) {
    this._visitables.remove(this.endpoint);
    if (endpoint != null) {
        this.endpoint = new PrismEndpointBuilder(endpoint);
        this._visitables.get("endpoint").add(this.endpoint);
    } else {
        this.endpoint = null;
        this._visitables.get("endpoint").remove(this.endpoint);
    }
    return (A) this;
  }
  
  public boolean hasEndpoint() {
    return this.endpoint != null;
  }
  
  public A withNewEndpoint(String address,Integer port) {
    return (A)withEndpoint(new PrismEndpoint(address, port));
  }
  
  public EndpointNested<A> withNewEndpoint() {
    return new EndpointNested(null);
  }
  
  public EndpointNested<A> withNewEndpointLike(PrismEndpoint item) {
    return new EndpointNested(item);
  }
  
  public EndpointNested<A> editEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(null));
  }
  
  public EndpointNested<A> editOrNewEndpoint() {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(new PrismEndpointBuilder().build()));
  }
  
  public EndpointNested<A> editOrNewEndpointLike(PrismEndpoint item) {
    return withNewEndpointLike(java.util.Optional.ofNullable(buildEndpoint()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getUuid() {
    return this.uuid;
  }
  
  public A withUuid(String uuid) {
    this.uuid = uuid;
    return (A) this;
  }
  
  public boolean hasUuid() {
    return this.uuid != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrismElementFluent that = (PrismElementFluent) o;
    if (!java.util.Objects.equals(endpoint, that.endpoint)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(uuid, that.uuid)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(endpoint,  name,  uuid,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endpoint != null) { sb.append("endpoint:"); sb.append(endpoint + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (uuid != null) { sb.append("uuid:"); sb.append(uuid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EndpointNested<N> extends PrismEndpointFluent<EndpointNested<N>> implements Nested<N>{
    EndpointNested(PrismEndpoint item) {
      this.builder = new PrismEndpointBuilder(this, item);
    }
    PrismEndpointBuilder builder;
    
    public N and() {
      return (N) PrismElementFluent.this.withEndpoint(builder.build());
    }
    
    public N endEndpoint() {
      return and();
    }
    
  
  }

}