package io.fabric8.openshift.api.model.installer.ovirt.v1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CPUFluent<A extends CPUFluent<A>> extends BaseFluent<A>{
  public CPUFluent() {
  }
  
  public CPUFluent(CPU instance) {
    this.copyInstance(instance);
  }
  private Integer cores;
  private Integer sockets;
  private Integer threads;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CPU instance) {
    instance = (instance != null ? instance : new CPU());
    if (instance != null) {
          this.withCores(instance.getCores());
          this.withSockets(instance.getSockets());
          this.withThreads(instance.getThreads());
          this.withCores(instance.getCores());
          this.withSockets(instance.getSockets());
          this.withThreads(instance.getThreads());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getCores() {
    return this.cores;
  }
  
  public A withCores(Integer cores) {
    this.cores = cores;
    return (A) this;
  }
  
  public boolean hasCores() {
    return this.cores != null;
  }
  
  public Integer getSockets() {
    return this.sockets;
  }
  
  public A withSockets(Integer sockets) {
    this.sockets = sockets;
    return (A) this;
  }
  
  public boolean hasSockets() {
    return this.sockets != null;
  }
  
  public Integer getThreads() {
    return this.threads;
  }
  
  public A withThreads(Integer threads) {
    this.threads = threads;
    return (A) this;
  }
  
  public boolean hasThreads() {
    return this.threads != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CPUFluent that = (CPUFluent) o;
    if (!java.util.Objects.equals(cores, that.cores)) return false;
    if (!java.util.Objects.equals(sockets, that.sockets)) return false;
    if (!java.util.Objects.equals(threads, that.threads)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cores,  sockets,  threads,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cores != null) { sb.append("cores:"); sb.append(cores + ","); }
    if (sockets != null) { sb.append("sockets:"); sb.append(sockets + ","); }
    if (threads != null) { sb.append("threads:"); sb.append(threads + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}