package io.fabric8.openshift.api.model.installer.powervs.v1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private Integer memoryGiB;
  private String procType;
  private IntOrStringBuilder processors;
  private String sysType;
  private List<String> volumeIDs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withMemoryGiB(instance.getMemoryGiB());
          this.withProcType(instance.getProcType());
          this.withProcessors(instance.getProcessors());
          this.withSysType(instance.getSysType());
          this.withVolumeIDs(instance.getVolumeIDs());
          this.withMemoryGiB(instance.getMemoryGiB());
          this.withProcType(instance.getProcType());
          this.withProcessors(instance.getProcessors());
          this.withSysType(instance.getSysType());
          this.withVolumeIDs(instance.getVolumeIDs());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getMemoryGiB() {
    return this.memoryGiB;
  }
  
  public A withMemoryGiB(Integer memoryGiB) {
    this.memoryGiB = memoryGiB;
    return (A) this;
  }
  
  public boolean hasMemoryGiB() {
    return this.memoryGiB != null;
  }
  
  public String getProcType() {
    return this.procType;
  }
  
  public A withProcType(String procType) {
    this.procType = procType;
    return (A) this;
  }
  
  public boolean hasProcType() {
    return this.procType != null;
  }
  
  public IntOrString buildProcessors() {
    return this.processors != null ? this.processors.build() : null;
  }
  
  public A withProcessors(IntOrString processors) {
    this._visitables.remove(this.processors);
    if (processors != null) {
        this.processors = new IntOrStringBuilder(processors);
        this._visitables.get("processors").add(this.processors);
    } else {
        this.processors = null;
        this._visitables.get("processors").remove(this.processors);
    }
    return (A) this;
  }
  
  public boolean hasProcessors() {
    return this.processors != null;
  }
  
  public A withNewProcessors(Object value) {
    return (A)withProcessors(new IntOrString(value));
  }
  
  public ProcessorsNested<A> withNewProcessors() {
    return new ProcessorsNested(null);
  }
  
  public ProcessorsNested<A> withNewProcessorsLike(IntOrString item) {
    return new ProcessorsNested(item);
  }
  
  public ProcessorsNested<A> editProcessors() {
    return withNewProcessorsLike(java.util.Optional.ofNullable(buildProcessors()).orElse(null));
  }
  
  public ProcessorsNested<A> editOrNewProcessors() {
    return withNewProcessorsLike(java.util.Optional.ofNullable(buildProcessors()).orElse(new IntOrStringBuilder().build()));
  }
  
  public ProcessorsNested<A> editOrNewProcessorsLike(IntOrString item) {
    return withNewProcessorsLike(java.util.Optional.ofNullable(buildProcessors()).orElse(item));
  }
  
  public String getSysType() {
    return this.sysType;
  }
  
  public A withSysType(String sysType) {
    this.sysType = sysType;
    return (A) this;
  }
  
  public boolean hasSysType() {
    return this.sysType != null;
  }
  
  public A addToVolumeIDs(int index,String item) {
    if (this.volumeIDs == null) {this.volumeIDs = new ArrayList<String>();}
    this.volumeIDs.add(index, item);
    return (A)this;
  }
  
  public A setToVolumeIDs(int index,String item) {
    if (this.volumeIDs == null) {this.volumeIDs = new ArrayList<String>();}
    this.volumeIDs.set(index, item); return (A)this;
  }
  
  public A addToVolumeIDs(java.lang.String... items) {
    if (this.volumeIDs == null) {this.volumeIDs = new ArrayList<String>();}
    for (String item : items) {this.volumeIDs.add(item);} return (A)this;
  }
  
  public A addAllToVolumeIDs(Collection<String> items) {
    if (this.volumeIDs == null) {this.volumeIDs = new ArrayList<String>();}
    for (String item : items) {this.volumeIDs.add(item);} return (A)this;
  }
  
  public A removeFromVolumeIDs(java.lang.String... items) {
    if (this.volumeIDs == null) return (A)this;
    for (String item : items) { this.volumeIDs.remove(item);} return (A)this;
  }
  
  public A removeAllFromVolumeIDs(Collection<String> items) {
    if (this.volumeIDs == null) return (A)this;
    for (String item : items) { this.volumeIDs.remove(item);} return (A)this;
  }
  
  public List<String> getVolumeIDs() {
    return this.volumeIDs;
  }
  
  public String getVolumeID(int index) {
    return this.volumeIDs.get(index);
  }
  
  public String getFirstVolumeID() {
    return this.volumeIDs.get(0);
  }
  
  public String getLastVolumeID() {
    return this.volumeIDs.get(volumeIDs.size() - 1);
  }
  
  public String getMatchingVolumeID(Predicate<String> predicate) {
      for (String item : volumeIDs) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeID(Predicate<String> predicate) {
      for (String item : volumeIDs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeIDs(List<String> volumeIDs) {
    if (volumeIDs != null) {
        this.volumeIDs = new ArrayList();
        for (String item : volumeIDs) {
          this.addToVolumeIDs(item);
        }
    } else {
      this.volumeIDs = null;
    }
    return (A) this;
  }
  
  public A withVolumeIDs(java.lang.String... volumeIDs) {
    if (this.volumeIDs != null) {this.volumeIDs.clear(); _visitables.remove("volumeIDs"); }
    if (volumeIDs != null) {for (String item :volumeIDs){ this.addToVolumeIDs(item);}} return (A) this;
  }
  
  public boolean hasVolumeIDs() {
    return this.volumeIDs != null && !this.volumeIDs.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(memoryGiB, that.memoryGiB)) return false;
    if (!java.util.Objects.equals(procType, that.procType)) return false;
    if (!java.util.Objects.equals(processors, that.processors)) return false;
    if (!java.util.Objects.equals(sysType, that.sysType)) return false;
    if (!java.util.Objects.equals(volumeIDs, that.volumeIDs)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(memoryGiB,  procType,  processors,  sysType,  volumeIDs,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (memoryGiB != null) { sb.append("memoryGiB:"); sb.append(memoryGiB + ","); }
    if (procType != null) { sb.append("procType:"); sb.append(procType + ","); }
    if (processors != null) { sb.append("processors:"); sb.append(processors + ","); }
    if (sysType != null) { sb.append("sysType:"); sb.append(sysType + ","); }
    if (volumeIDs != null && !volumeIDs.isEmpty()) { sb.append("volumeIDs:"); sb.append(volumeIDs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ProcessorsNested<N> extends IntOrStringFluent<ProcessorsNested<N>> implements Nested<N>{
    ProcessorsNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withProcessors(builder.build());
    }
    
    public N endProcessors() {
      return and();
    }
    
  
  }

}