package io.fabric8.openshift.api.model.installer.powervs.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  
  public PlatformFluent(Platform instance) {
    this.copyInstance(instance);
  }
  private String cloudConnectionName;
  private String clusterOSImage;
  private MachinePoolBuilder defaultMachinePlatform;
  private String powervsResourceGroup;
  private String pvsNetworkName;
  private String region;
  private String serviceInstanceID;
  private String userID;
  private String vpcName;
  private String vpcRegion;
  private List<String> vpcSubnets = new ArrayList<String>();
  private String zone;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Platform instance) {
    instance = (instance != null ? instance : new Platform());
    if (instance != null) {
          this.withCloudConnectionName(instance.getCloudConnectionName());
          this.withClusterOSImage(instance.getClusterOSImage());
          this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
          this.withPowervsResourceGroup(instance.getPowervsResourceGroup());
          this.withPvsNetworkName(instance.getPvsNetworkName());
          this.withRegion(instance.getRegion());
          this.withServiceInstanceID(instance.getServiceInstanceID());
          this.withUserID(instance.getUserID());
          this.withVpcName(instance.getVpcName());
          this.withVpcRegion(instance.getVpcRegion());
          this.withVpcSubnets(instance.getVpcSubnets());
          this.withZone(instance.getZone());
          this.withCloudConnectionName(instance.getCloudConnectionName());
          this.withClusterOSImage(instance.getClusterOSImage());
          this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
          this.withPowervsResourceGroup(instance.getPowervsResourceGroup());
          this.withPvsNetworkName(instance.getPvsNetworkName());
          this.withRegion(instance.getRegion());
          this.withServiceInstanceID(instance.getServiceInstanceID());
          this.withUserID(instance.getUserID());
          this.withVpcName(instance.getVpcName());
          this.withVpcRegion(instance.getVpcRegion());
          this.withVpcSubnets(instance.getVpcSubnets());
          this.withZone(instance.getZone());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCloudConnectionName() {
    return this.cloudConnectionName;
  }
  
  public A withCloudConnectionName(String cloudConnectionName) {
    this.cloudConnectionName = cloudConnectionName;
    return (A) this;
  }
  
  public boolean hasCloudConnectionName() {
    return this.cloudConnectionName != null;
  }
  
  public String getClusterOSImage() {
    return this.clusterOSImage;
  }
  
  public A withClusterOSImage(String clusterOSImage) {
    this.clusterOSImage = clusterOSImage;
    return (A) this;
  }
  
  public boolean hasClusterOSImage() {
    return this.clusterOSImage != null;
  }
  
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
  }
  
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    this._visitables.remove(this.defaultMachinePlatform);
    if (defaultMachinePlatform != null) {
        this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
        this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
    } else {
        this.defaultMachinePlatform = null;
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    }
    return (A) this;
  }
  
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  
  public String getPowervsResourceGroup() {
    return this.powervsResourceGroup;
  }
  
  public A withPowervsResourceGroup(String powervsResourceGroup) {
    this.powervsResourceGroup = powervsResourceGroup;
    return (A) this;
  }
  
  public boolean hasPowervsResourceGroup() {
    return this.powervsResourceGroup != null;
  }
  
  public String getPvsNetworkName() {
    return this.pvsNetworkName;
  }
  
  public A withPvsNetworkName(String pvsNetworkName) {
    this.pvsNetworkName = pvsNetworkName;
    return (A) this;
  }
  
  public boolean hasPvsNetworkName() {
    return this.pvsNetworkName != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public String getServiceInstanceID() {
    return this.serviceInstanceID;
  }
  
  public A withServiceInstanceID(String serviceInstanceID) {
    this.serviceInstanceID = serviceInstanceID;
    return (A) this;
  }
  
  public boolean hasServiceInstanceID() {
    return this.serviceInstanceID != null;
  }
  
  public String getUserID() {
    return this.userID;
  }
  
  public A withUserID(String userID) {
    this.userID = userID;
    return (A) this;
  }
  
  public boolean hasUserID() {
    return this.userID != null;
  }
  
  public String getVpcName() {
    return this.vpcName;
  }
  
  public A withVpcName(String vpcName) {
    this.vpcName = vpcName;
    return (A) this;
  }
  
  public boolean hasVpcName() {
    return this.vpcName != null;
  }
  
  public String getVpcRegion() {
    return this.vpcRegion;
  }
  
  public A withVpcRegion(String vpcRegion) {
    this.vpcRegion = vpcRegion;
    return (A) this;
  }
  
  public boolean hasVpcRegion() {
    return this.vpcRegion != null;
  }
  
  public A addToVpcSubnets(int index,String item) {
    if (this.vpcSubnets == null) {this.vpcSubnets = new ArrayList<String>();}
    this.vpcSubnets.add(index, item);
    return (A)this;
  }
  
  public A setToVpcSubnets(int index,String item) {
    if (this.vpcSubnets == null) {this.vpcSubnets = new ArrayList<String>();}
    this.vpcSubnets.set(index, item); return (A)this;
  }
  
  public A addToVpcSubnets(java.lang.String... items) {
    if (this.vpcSubnets == null) {this.vpcSubnets = new ArrayList<String>();}
    for (String item : items) {this.vpcSubnets.add(item);} return (A)this;
  }
  
  public A addAllToVpcSubnets(Collection<String> items) {
    if (this.vpcSubnets == null) {this.vpcSubnets = new ArrayList<String>();}
    for (String item : items) {this.vpcSubnets.add(item);} return (A)this;
  }
  
  public A removeFromVpcSubnets(java.lang.String... items) {
    if (this.vpcSubnets == null) return (A)this;
    for (String item : items) { this.vpcSubnets.remove(item);} return (A)this;
  }
  
  public A removeAllFromVpcSubnets(Collection<String> items) {
    if (this.vpcSubnets == null) return (A)this;
    for (String item : items) { this.vpcSubnets.remove(item);} return (A)this;
  }
  
  public List<String> getVpcSubnets() {
    return this.vpcSubnets;
  }
  
  public String getVpcSubnet(int index) {
    return this.vpcSubnets.get(index);
  }
  
  public String getFirstVpcSubnet() {
    return this.vpcSubnets.get(0);
  }
  
  public String getLastVpcSubnet() {
    return this.vpcSubnets.get(vpcSubnets.size() - 1);
  }
  
  public String getMatchingVpcSubnet(Predicate<String> predicate) {
      for (String item : vpcSubnets) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVpcSubnet(Predicate<String> predicate) {
      for (String item : vpcSubnets) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVpcSubnets(List<String> vpcSubnets) {
    if (vpcSubnets != null) {
        this.vpcSubnets = new ArrayList();
        for (String item : vpcSubnets) {
          this.addToVpcSubnets(item);
        }
    } else {
      this.vpcSubnets = null;
    }
    return (A) this;
  }
  
  public A withVpcSubnets(java.lang.String... vpcSubnets) {
    if (this.vpcSubnets != null) {this.vpcSubnets.clear(); _visitables.remove("vpcSubnets"); }
    if (vpcSubnets != null) {for (String item :vpcSubnets){ this.addToVpcSubnets(item);}} return (A) this;
  }
  
  public boolean hasVpcSubnets() {
    return this.vpcSubnets != null && !this.vpcSubnets.isEmpty();
  }
  
  public String getZone() {
    return this.zone;
  }
  
  public A withZone(String zone) {
    this.zone = zone;
    return (A) this;
  }
  
  public boolean hasZone() {
    return this.zone != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(cloudConnectionName, that.cloudConnectionName)) return false;
    if (!java.util.Objects.equals(clusterOSImage, that.clusterOSImage)) return false;
    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;
    if (!java.util.Objects.equals(powervsResourceGroup, that.powervsResourceGroup)) return false;
    if (!java.util.Objects.equals(pvsNetworkName, that.pvsNetworkName)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(serviceInstanceID, that.serviceInstanceID)) return false;
    if (!java.util.Objects.equals(userID, that.userID)) return false;
    if (!java.util.Objects.equals(vpcName, that.vpcName)) return false;
    if (!java.util.Objects.equals(vpcRegion, that.vpcRegion)) return false;
    if (!java.util.Objects.equals(vpcSubnets, that.vpcSubnets)) return false;
    if (!java.util.Objects.equals(zone, that.zone)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloudConnectionName,  clusterOSImage,  defaultMachinePlatform,  powervsResourceGroup,  pvsNetworkName,  region,  serviceInstanceID,  userID,  vpcName,  vpcRegion,  vpcSubnets,  zone,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudConnectionName != null) { sb.append("cloudConnectionName:"); sb.append(cloudConnectionName + ","); }
    if (clusterOSImage != null) { sb.append("clusterOSImage:"); sb.append(clusterOSImage + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (powervsResourceGroup != null) { sb.append("powervsResourceGroup:"); sb.append(powervsResourceGroup + ","); }
    if (pvsNetworkName != null) { sb.append("pvsNetworkName:"); sb.append(pvsNetworkName + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (serviceInstanceID != null) { sb.append("serviceInstanceID:"); sb.append(serviceInstanceID + ","); }
    if (userID != null) { sb.append("userID:"); sb.append(userID + ","); }
    if (vpcName != null) { sb.append("vpcName:"); sb.append(vpcName + ","); }
    if (vpcRegion != null) { sb.append("vpcRegion:"); sb.append(vpcRegion + ","); }
    if (vpcSubnets != null && !vpcSubnets.isEmpty()) { sb.append("vpcSubnets:"); sb.append(vpcSubnets + ","); }
    if (zone != null) { sb.append("zone:"); sb.append(zone + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  
  }

}