package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class InstallConfigFluent<A extends InstallConfigFluent<A>> extends BaseFluent<A>{
  public InstallConfigFluent() {
  }
  
  public InstallConfigFluent(InstallConfig instance) {
    this.copyInstance(instance);
  }
  private String additionalTrustBundle;
  private String additionalTrustBundlePolicy;
  private String apiVersion;
  private String baseDomain;
  private BootstrapInPlaceBuilder bootstrapInPlace;
  private CapabilitiesBuilder capabilities;
  private ArrayList<MachinePoolBuilder> compute = new ArrayList<MachinePoolBuilder>();
  private MachinePoolBuilder controlPlane;
  private String cpuPartitioningMode;
  private String credentialsMode;
  private String featureSet;
  private Boolean fips;
  private ArrayList<ImageContentSourceBuilder> imageContentSources = new ArrayList<ImageContentSourceBuilder>();
  private String kind;
  private ObjectMetaBuilder metadata;
  private NetworkingBuilder networking;
  private PlatformBuilder platform;
  private ProxyBuilder proxy;
  private String publish;
  private String pullSecret;
  private String sshKey;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(InstallConfig instance) {
    instance = (instance != null ? instance : new InstallConfig());
    if (instance != null) {
          this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
          this.withAdditionalTrustBundlePolicy(instance.getAdditionalTrustBundlePolicy());
          this.withApiVersion(instance.getApiVersion());
          this.withBaseDomain(instance.getBaseDomain());
          this.withBootstrapInPlace(instance.getBootstrapInPlace());
          this.withCapabilities(instance.getCapabilities());
          this.withCompute(instance.getCompute());
          this.withControlPlane(instance.getControlPlane());
          this.withCpuPartitioningMode(instance.getCpuPartitioningMode());
          this.withCredentialsMode(instance.getCredentialsMode());
          this.withFeatureSet(instance.getFeatureSet());
          this.withFips(instance.getFips());
          this.withImageContentSources(instance.getImageContentSources());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withNetworking(instance.getNetworking());
          this.withPlatform(instance.getPlatform());
          this.withProxy(instance.getProxy());
          this.withPublish(instance.getPublish());
          this.withPullSecret(instance.getPullSecret());
          this.withSshKey(instance.getSshKey());
          this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
          this.withAdditionalTrustBundlePolicy(instance.getAdditionalTrustBundlePolicy());
          this.withApiVersion(instance.getApiVersion());
          this.withBaseDomain(instance.getBaseDomain());
          this.withBootstrapInPlace(instance.getBootstrapInPlace());
          this.withCapabilities(instance.getCapabilities());
          this.withCompute(instance.getCompute());
          this.withControlPlane(instance.getControlPlane());
          this.withCpuPartitioningMode(instance.getCpuPartitioningMode());
          this.withCredentialsMode(instance.getCredentialsMode());
          this.withFeatureSet(instance.getFeatureSet());
          this.withFips(instance.getFips());
          this.withImageContentSources(instance.getImageContentSources());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withNetworking(instance.getNetworking());
          this.withPlatform(instance.getPlatform());
          this.withProxy(instance.getProxy());
          this.withPublish(instance.getPublish());
          this.withPullSecret(instance.getPullSecret());
          this.withSshKey(instance.getSshKey());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAdditionalTrustBundle() {
    return this.additionalTrustBundle;
  }
  
  public A withAdditionalTrustBundle(String additionalTrustBundle) {
    this.additionalTrustBundle = additionalTrustBundle;
    return (A) this;
  }
  
  public boolean hasAdditionalTrustBundle() {
    return this.additionalTrustBundle != null;
  }
  
  public String getAdditionalTrustBundlePolicy() {
    return this.additionalTrustBundlePolicy;
  }
  
  public A withAdditionalTrustBundlePolicy(String additionalTrustBundlePolicy) {
    this.additionalTrustBundlePolicy = additionalTrustBundlePolicy;
    return (A) this;
  }
  
  public boolean hasAdditionalTrustBundlePolicy() {
    return this.additionalTrustBundlePolicy != null;
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public String getBaseDomain() {
    return this.baseDomain;
  }
  
  public A withBaseDomain(String baseDomain) {
    this.baseDomain = baseDomain;
    return (A) this;
  }
  
  public boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  public BootstrapInPlace buildBootstrapInPlace() {
    return this.bootstrapInPlace != null ? this.bootstrapInPlace.build() : null;
  }
  
  public A withBootstrapInPlace(BootstrapInPlace bootstrapInPlace) {
    this._visitables.remove(this.bootstrapInPlace);
    if (bootstrapInPlace != null) {
        this.bootstrapInPlace = new BootstrapInPlaceBuilder(bootstrapInPlace);
        this._visitables.get("bootstrapInPlace").add(this.bootstrapInPlace);
    } else {
        this.bootstrapInPlace = null;
        this._visitables.get("bootstrapInPlace").remove(this.bootstrapInPlace);
    }
    return (A) this;
  }
  
  public boolean hasBootstrapInPlace() {
    return this.bootstrapInPlace != null;
  }
  
  public A withNewBootstrapInPlace(String installationDisk) {
    return (A)withBootstrapInPlace(new BootstrapInPlace(installationDisk));
  }
  
  public BootstrapInPlaceNested<A> withNewBootstrapInPlace() {
    return new BootstrapInPlaceNested(null);
  }
  
  public BootstrapInPlaceNested<A> withNewBootstrapInPlaceLike(BootstrapInPlace item) {
    return new BootstrapInPlaceNested(item);
  }
  
  public BootstrapInPlaceNested<A> editBootstrapInPlace() {
    return withNewBootstrapInPlaceLike(java.util.Optional.ofNullable(buildBootstrapInPlace()).orElse(null));
  }
  
  public BootstrapInPlaceNested<A> editOrNewBootstrapInPlace() {
    return withNewBootstrapInPlaceLike(java.util.Optional.ofNullable(buildBootstrapInPlace()).orElse(new BootstrapInPlaceBuilder().build()));
  }
  
  public BootstrapInPlaceNested<A> editOrNewBootstrapInPlaceLike(BootstrapInPlace item) {
    return withNewBootstrapInPlaceLike(java.util.Optional.ofNullable(buildBootstrapInPlace()).orElse(item));
  }
  
  public Capabilities buildCapabilities() {
    return this.capabilities != null ? this.capabilities.build() : null;
  }
  
  public A withCapabilities(Capabilities capabilities) {
    this._visitables.remove(this.capabilities);
    if (capabilities != null) {
        this.capabilities = new CapabilitiesBuilder(capabilities);
        this._visitables.get("capabilities").add(this.capabilities);
    } else {
        this.capabilities = null;
        this._visitables.get("capabilities").remove(this.capabilities);
    }
    return (A) this;
  }
  
  public boolean hasCapabilities() {
    return this.capabilities != null;
  }
  
  public CapabilitiesNested<A> withNewCapabilities() {
    return new CapabilitiesNested(null);
  }
  
  public CapabilitiesNested<A> withNewCapabilitiesLike(Capabilities item) {
    return new CapabilitiesNested(item);
  }
  
  public CapabilitiesNested<A> editCapabilities() {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(null));
  }
  
  public CapabilitiesNested<A> editOrNewCapabilities() {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(new CapabilitiesBuilder().build()));
  }
  
  public CapabilitiesNested<A> editOrNewCapabilitiesLike(Capabilities item) {
    return withNewCapabilitiesLike(java.util.Optional.ofNullable(buildCapabilities()).orElse(item));
  }
  
  public A addToCompute(int index,MachinePool item) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    MachinePoolBuilder builder = new MachinePoolBuilder(item);
    if (index < 0 || index >= compute.size()) { _visitables.get("compute").add(builder); compute.add(builder); } else { _visitables.get("compute").add(index, builder); compute.add(index, builder);}
    return (A)this;
  }
  
  public A setToCompute(int index,MachinePool item) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    MachinePoolBuilder builder = new MachinePoolBuilder(item);
    if (index < 0 || index >= compute.size()) { _visitables.get("compute").add(builder); compute.add(builder); } else { _visitables.get("compute").set(index, builder); compute.set(index, builder);}
    return (A)this;
  }
  
  public A addToCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... items) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(builder);this.compute.add(builder);} return (A)this;
  }
  
  public A addAllToCompute(Collection<MachinePool> items) {
    if (this.compute == null) {this.compute = new ArrayList<MachinePoolBuilder>();}
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").add(builder);this.compute.add(builder);} return (A)this;
  }
  
  public A removeFromCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... items) {
    if (this.compute == null) return (A)this;
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").remove(builder); this.compute.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCompute(Collection<MachinePool> items) {
    if (this.compute == null) return (A)this;
    for (MachinePool item : items) {MachinePoolBuilder builder = new MachinePoolBuilder(item);_visitables.get("compute").remove(builder); this.compute.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCompute(Predicate<MachinePoolBuilder> predicate) {
    if (compute == null) return (A) this;
    final Iterator<MachinePoolBuilder> each = compute.iterator();
    final List visitables = _visitables.get("compute");
    while (each.hasNext()) {
      MachinePoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachinePool> buildCompute() {
    return this.compute != null ? build(compute) : null;
  }
  
  public MachinePool buildCompute(int index) {
    return this.compute.get(index).build();
  }
  
  public MachinePool buildFirstCompute() {
    return this.compute.get(0).build();
  }
  
  public MachinePool buildLastCompute() {
    return this.compute.get(compute.size() - 1).build();
  }
  
  public MachinePool buildMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
      for (MachinePoolBuilder item : compute) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
      for (MachinePoolBuilder item : compute) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCompute(List<MachinePool> compute) {
    if (this.compute != null) {
      this._visitables.get("compute").clear();
    }
    if (compute != null) {
        this.compute = new ArrayList();
        for (MachinePool item : compute) {
          this.addToCompute(item);
        }
    } else {
      this.compute = null;
    }
    return (A) this;
  }
  
  public A withCompute(io.fabric8.openshift.api.model.installer.v1.MachinePool... compute) {
    if (this.compute != null) {this.compute.clear(); _visitables.remove("compute"); }
    if (compute != null) {for (MachinePool item :compute){ this.addToCompute(item);}} return (A) this;
  }
  
  public boolean hasCompute() {
    return this.compute != null && !this.compute.isEmpty();
  }
  
  public ComputeNested<A> addNewCompute() {
    return new ComputeNested(-1, null);
  }
  
  public ComputeNested<A> addNewComputeLike(MachinePool item) {
    return new ComputeNested(-1, item);
  }
  
  public ComputeNested<A> setNewComputeLike(int index,MachinePool item) {
    return new ComputeNested(index, item);
  }
  
  public ComputeNested<A> editCompute(int index) {
    if (compute.size() <= index) throw new RuntimeException("Can't edit compute. Index exceeds size.");
    return setNewComputeLike(index, buildCompute(index));
  }
  
  public ComputeNested<A> editFirstCompute() {
    if (compute.size() == 0) throw new RuntimeException("Can't edit first compute. The list is empty.");
    return setNewComputeLike(0, buildCompute(0));
  }
  
  public ComputeNested<A> editLastCompute() {
    int index = compute.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last compute. The list is empty.");
    return setNewComputeLike(index, buildCompute(index));
  }
  
  public ComputeNested<A> editMatchingCompute(Predicate<MachinePoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<compute.size();i++) { 
    if (predicate.test(compute.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching compute. No match found.");
    return setNewComputeLike(index, buildCompute(index));
  }
  
  public MachinePool buildControlPlane() {
    return this.controlPlane != null ? this.controlPlane.build() : null;
  }
  
  public A withControlPlane(MachinePool controlPlane) {
    this._visitables.remove(this.controlPlane);
    if (controlPlane != null) {
        this.controlPlane = new MachinePoolBuilder(controlPlane);
        this._visitables.get("controlPlane").add(this.controlPlane);
    } else {
        this.controlPlane = null;
        this._visitables.get("controlPlane").remove(this.controlPlane);
    }
    return (A) this;
  }
  
  public boolean hasControlPlane() {
    return this.controlPlane != null;
  }
  
  public ControlPlaneNested<A> withNewControlPlane() {
    return new ControlPlaneNested(null);
  }
  
  public ControlPlaneNested<A> withNewControlPlaneLike(MachinePool item) {
    return new ControlPlaneNested(item);
  }
  
  public ControlPlaneNested<A> editControlPlane() {
    return withNewControlPlaneLike(java.util.Optional.ofNullable(buildControlPlane()).orElse(null));
  }
  
  public ControlPlaneNested<A> editOrNewControlPlane() {
    return withNewControlPlaneLike(java.util.Optional.ofNullable(buildControlPlane()).orElse(new MachinePoolBuilder().build()));
  }
  
  public ControlPlaneNested<A> editOrNewControlPlaneLike(MachinePool item) {
    return withNewControlPlaneLike(java.util.Optional.ofNullable(buildControlPlane()).orElse(item));
  }
  
  public String getCpuPartitioningMode() {
    return this.cpuPartitioningMode;
  }
  
  public A withCpuPartitioningMode(String cpuPartitioningMode) {
    this.cpuPartitioningMode = cpuPartitioningMode;
    return (A) this;
  }
  
  public boolean hasCpuPartitioningMode() {
    return this.cpuPartitioningMode != null;
  }
  
  public String getCredentialsMode() {
    return this.credentialsMode;
  }
  
  public A withCredentialsMode(String credentialsMode) {
    this.credentialsMode = credentialsMode;
    return (A) this;
  }
  
  public boolean hasCredentialsMode() {
    return this.credentialsMode != null;
  }
  
  public String getFeatureSet() {
    return this.featureSet;
  }
  
  public A withFeatureSet(String featureSet) {
    this.featureSet = featureSet;
    return (A) this;
  }
  
  public boolean hasFeatureSet() {
    return this.featureSet != null;
  }
  
  public Boolean getFips() {
    return this.fips;
  }
  
  public A withFips(Boolean fips) {
    this.fips = fips;
    return (A) this;
  }
  
  public boolean hasFips() {
    return this.fips != null;
  }
  
  public A addToImageContentSources(int index,ImageContentSource item) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
    if (index < 0 || index >= imageContentSources.size()) { _visitables.get("imageContentSources").add(builder); imageContentSources.add(builder); } else { _visitables.get("imageContentSources").add(index, builder); imageContentSources.add(index, builder);}
    return (A)this;
  }
  
  public A setToImageContentSources(int index,ImageContentSource item) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);
    if (index < 0 || index >= imageContentSources.size()) { _visitables.get("imageContentSources").add(builder); imageContentSources.add(builder); } else { _visitables.get("imageContentSources").set(index, builder); imageContentSources.set(index, builder);}
    return (A)this;
  }
  
  public A addToImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... items) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(builder);this.imageContentSources.add(builder);} return (A)this;
  }
  
  public A addAllToImageContentSources(Collection<ImageContentSource> items) {
    if (this.imageContentSources == null) {this.imageContentSources = new ArrayList<ImageContentSourceBuilder>();}
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").add(builder);this.imageContentSources.add(builder);} return (A)this;
  }
  
  public A removeFromImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... items) {
    if (this.imageContentSources == null) return (A)this;
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").remove(builder); this.imageContentSources.remove(builder);} return (A)this;
  }
  
  public A removeAllFromImageContentSources(Collection<ImageContentSource> items) {
    if (this.imageContentSources == null) return (A)this;
    for (ImageContentSource item : items) {ImageContentSourceBuilder builder = new ImageContentSourceBuilder(item);_visitables.get("imageContentSources").remove(builder); this.imageContentSources.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromImageContentSources(Predicate<ImageContentSourceBuilder> predicate) {
    if (imageContentSources == null) return (A) this;
    final Iterator<ImageContentSourceBuilder> each = imageContentSources.iterator();
    final List visitables = _visitables.get("imageContentSources");
    while (each.hasNext()) {
      ImageContentSourceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ImageContentSource> buildImageContentSources() {
    return this.imageContentSources != null ? build(imageContentSources) : null;
  }
  
  public ImageContentSource buildImageContentSource(int index) {
    return this.imageContentSources.get(index).build();
  }
  
  public ImageContentSource buildFirstImageContentSource() {
    return this.imageContentSources.get(0).build();
  }
  
  public ImageContentSource buildLastImageContentSource() {
    return this.imageContentSources.get(imageContentSources.size() - 1).build();
  }
  
  public ImageContentSource buildMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
      for (ImageContentSourceBuilder item : imageContentSources) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
      for (ImageContentSourceBuilder item : imageContentSources) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withImageContentSources(List<ImageContentSource> imageContentSources) {
    if (this.imageContentSources != null) {
      this._visitables.get("imageContentSources").clear();
    }
    if (imageContentSources != null) {
        this.imageContentSources = new ArrayList();
        for (ImageContentSource item : imageContentSources) {
          this.addToImageContentSources(item);
        }
    } else {
      this.imageContentSources = null;
    }
    return (A) this;
  }
  
  public A withImageContentSources(io.fabric8.openshift.api.model.installer.v1.ImageContentSource... imageContentSources) {
    if (this.imageContentSources != null) {this.imageContentSources.clear(); _visitables.remove("imageContentSources"); }
    if (imageContentSources != null) {for (ImageContentSource item :imageContentSources){ this.addToImageContentSources(item);}} return (A) this;
  }
  
  public boolean hasImageContentSources() {
    return this.imageContentSources != null && !this.imageContentSources.isEmpty();
  }
  
  public ImageContentSourcesNested<A> addNewImageContentSource() {
    return new ImageContentSourcesNested(-1, null);
  }
  
  public ImageContentSourcesNested<A> addNewImageContentSourceLike(ImageContentSource item) {
    return new ImageContentSourcesNested(-1, item);
  }
  
  public ImageContentSourcesNested<A> setNewImageContentSourceLike(int index,ImageContentSource item) {
    return new ImageContentSourcesNested(index, item);
  }
  
  public ImageContentSourcesNested<A> editImageContentSource(int index) {
    if (imageContentSources.size() <= index) throw new RuntimeException("Can't edit imageContentSources. Index exceeds size.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  
  public ImageContentSourcesNested<A> editFirstImageContentSource() {
    if (imageContentSources.size() == 0) throw new RuntimeException("Can't edit first imageContentSources. The list is empty.");
    return setNewImageContentSourceLike(0, buildImageContentSource(0));
  }
  
  public ImageContentSourcesNested<A> editLastImageContentSource() {
    int index = imageContentSources.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last imageContentSources. The list is empty.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  
  public ImageContentSourcesNested<A> editMatchingImageContentSource(Predicate<ImageContentSourceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<imageContentSources.size();i++) { 
    if (predicate.test(imageContentSources.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching imageContentSources. No match found.");
    return setNewImageContentSourceLike(index, buildImageContentSource(index));
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove(this.metadata);
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public Networking buildNetworking() {
    return this.networking != null ? this.networking.build() : null;
  }
  
  public A withNetworking(Networking networking) {
    this._visitables.remove(this.networking);
    if (networking != null) {
        this.networking = new NetworkingBuilder(networking);
        this._visitables.get("networking").add(this.networking);
    } else {
        this.networking = null;
        this._visitables.get("networking").remove(this.networking);
    }
    return (A) this;
  }
  
  public boolean hasNetworking() {
    return this.networking != null;
  }
  
  public NetworkingNested<A> withNewNetworking() {
    return new NetworkingNested(null);
  }
  
  public NetworkingNested<A> withNewNetworkingLike(Networking item) {
    return new NetworkingNested(item);
  }
  
  public NetworkingNested<A> editNetworking() {
    return withNewNetworkingLike(java.util.Optional.ofNullable(buildNetworking()).orElse(null));
  }
  
  public NetworkingNested<A> editOrNewNetworking() {
    return withNewNetworkingLike(java.util.Optional.ofNullable(buildNetworking()).orElse(new NetworkingBuilder().build()));
  }
  
  public NetworkingNested<A> editOrNewNetworkingLike(Networking item) {
    return withNewNetworkingLike(java.util.Optional.ofNullable(buildNetworking()).orElse(item));
  }
  
  public Platform buildPlatform() {
    return this.platform != null ? this.platform.build() : null;
  }
  
  public A withPlatform(Platform platform) {
    this._visitables.remove(this.platform);
    if (platform != null) {
        this.platform = new PlatformBuilder(platform);
        this._visitables.get("platform").add(this.platform);
    } else {
        this.platform = null;
        this._visitables.get("platform").remove(this.platform);
    }
    return (A) this;
  }
  
  public boolean hasPlatform() {
    return this.platform != null;
  }
  
  public PlatformNested<A> withNewPlatform() {
    return new PlatformNested(null);
  }
  
  public PlatformNested<A> withNewPlatformLike(Platform item) {
    return new PlatformNested(item);
  }
  
  public PlatformNested<A> editPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(null));
  }
  
  public PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(new PlatformBuilder().build()));
  }
  
  public PlatformNested<A> editOrNewPlatformLike(Platform item) {
    return withNewPlatformLike(java.util.Optional.ofNullable(buildPlatform()).orElse(item));
  }
  
  public Proxy buildProxy() {
    return this.proxy != null ? this.proxy.build() : null;
  }
  
  public A withProxy(Proxy proxy) {
    this._visitables.remove(this.proxy);
    if (proxy != null) {
        this.proxy = new ProxyBuilder(proxy);
        this._visitables.get("proxy").add(this.proxy);
    } else {
        this.proxy = null;
        this._visitables.get("proxy").remove(this.proxy);
    }
    return (A) this;
  }
  
  public boolean hasProxy() {
    return this.proxy != null;
  }
  
  public A withNewProxy(String httpProxy,String httpsProxy,String noProxy) {
    return (A)withProxy(new Proxy(httpProxy, httpsProxy, noProxy));
  }
  
  public ProxyNested<A> withNewProxy() {
    return new ProxyNested(null);
  }
  
  public ProxyNested<A> withNewProxyLike(Proxy item) {
    return new ProxyNested(item);
  }
  
  public ProxyNested<A> editProxy() {
    return withNewProxyLike(java.util.Optional.ofNullable(buildProxy()).orElse(null));
  }
  
  public ProxyNested<A> editOrNewProxy() {
    return withNewProxyLike(java.util.Optional.ofNullable(buildProxy()).orElse(new ProxyBuilder().build()));
  }
  
  public ProxyNested<A> editOrNewProxyLike(Proxy item) {
    return withNewProxyLike(java.util.Optional.ofNullable(buildProxy()).orElse(item));
  }
  
  public String getPublish() {
    return this.publish;
  }
  
  public A withPublish(String publish) {
    this.publish = publish;
    return (A) this;
  }
  
  public boolean hasPublish() {
    return this.publish != null;
  }
  
  public String getPullSecret() {
    return this.pullSecret;
  }
  
  public A withPullSecret(String pullSecret) {
    this.pullSecret = pullSecret;
    return (A) this;
  }
  
  public boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  
  public String getSshKey() {
    return this.sshKey;
  }
  
  public A withSshKey(String sshKey) {
    this.sshKey = sshKey;
    return (A) this;
  }
  
  public boolean hasSshKey() {
    return this.sshKey != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InstallConfigFluent that = (InstallConfigFluent) o;
    if (!java.util.Objects.equals(additionalTrustBundle, that.additionalTrustBundle)) return false;
    if (!java.util.Objects.equals(additionalTrustBundlePolicy, that.additionalTrustBundlePolicy)) return false;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(baseDomain, that.baseDomain)) return false;
    if (!java.util.Objects.equals(bootstrapInPlace, that.bootstrapInPlace)) return false;
    if (!java.util.Objects.equals(capabilities, that.capabilities)) return false;
    if (!java.util.Objects.equals(compute, that.compute)) return false;
    if (!java.util.Objects.equals(controlPlane, that.controlPlane)) return false;
    if (!java.util.Objects.equals(cpuPartitioningMode, that.cpuPartitioningMode)) return false;
    if (!java.util.Objects.equals(credentialsMode, that.credentialsMode)) return false;
    if (!java.util.Objects.equals(featureSet, that.featureSet)) return false;
    if (!java.util.Objects.equals(fips, that.fips)) return false;
    if (!java.util.Objects.equals(imageContentSources, that.imageContentSources)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(networking, that.networking)) return false;
    if (!java.util.Objects.equals(platform, that.platform)) return false;
    if (!java.util.Objects.equals(proxy, that.proxy)) return false;
    if (!java.util.Objects.equals(publish, that.publish)) return false;
    if (!java.util.Objects.equals(pullSecret, that.pullSecret)) return false;
    if (!java.util.Objects.equals(sshKey, that.sshKey)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalTrustBundle,  additionalTrustBundlePolicy,  apiVersion,  baseDomain,  bootstrapInPlace,  capabilities,  compute,  controlPlane,  cpuPartitioningMode,  credentialsMode,  featureSet,  fips,  imageContentSources,  kind,  metadata,  networking,  platform,  proxy,  publish,  pullSecret,  sshKey,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTrustBundle != null) { sb.append("additionalTrustBundle:"); sb.append(additionalTrustBundle + ","); }
    if (additionalTrustBundlePolicy != null) { sb.append("additionalTrustBundlePolicy:"); sb.append(additionalTrustBundlePolicy + ","); }
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (bootstrapInPlace != null) { sb.append("bootstrapInPlace:"); sb.append(bootstrapInPlace + ","); }
    if (capabilities != null) { sb.append("capabilities:"); sb.append(capabilities + ","); }
    if (compute != null && !compute.isEmpty()) { sb.append("compute:"); sb.append(compute + ","); }
    if (controlPlane != null) { sb.append("controlPlane:"); sb.append(controlPlane + ","); }
    if (cpuPartitioningMode != null) { sb.append("cpuPartitioningMode:"); sb.append(cpuPartitioningMode + ","); }
    if (credentialsMode != null) { sb.append("credentialsMode:"); sb.append(credentialsMode + ","); }
    if (featureSet != null) { sb.append("featureSet:"); sb.append(featureSet + ","); }
    if (fips != null) { sb.append("fips:"); sb.append(fips + ","); }
    if (imageContentSources != null && !imageContentSources.isEmpty()) { sb.append("imageContentSources:"); sb.append(imageContentSources + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (networking != null) { sb.append("networking:"); sb.append(networking + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (proxy != null) { sb.append("proxy:"); sb.append(proxy + ","); }
    if (publish != null) { sb.append("publish:"); sb.append(publish + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (sshKey != null) { sb.append("sshKey:"); sb.append(sshKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withFips() {
    return withFips(true);
  }
  public class BootstrapInPlaceNested<N> extends BootstrapInPlaceFluent<BootstrapInPlaceNested<N>> implements Nested<N>{
    BootstrapInPlaceNested(BootstrapInPlace item) {
      this.builder = new BootstrapInPlaceBuilder(this, item);
    }
    BootstrapInPlaceBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withBootstrapInPlace(builder.build());
    }
    
    public N endBootstrapInPlace() {
      return and();
    }
    
  
  }
  public class CapabilitiesNested<N> extends CapabilitiesFluent<CapabilitiesNested<N>> implements Nested<N>{
    CapabilitiesNested(Capabilities item) {
      this.builder = new CapabilitiesBuilder(this, item);
    }
    CapabilitiesBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withCapabilities(builder.build());
    }
    
    public N endCapabilities() {
      return and();
    }
    
  
  }
  public class ComputeNested<N> extends MachinePoolFluent<ComputeNested<N>> implements Nested<N>{
    ComputeNested(int index,MachinePool item) {
      this.index = index;
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    int index;
    
    public N and() {
      return (N) InstallConfigFluent.this.setToCompute(index,builder.build());
    }
    
    public N endCompute() {
      return and();
    }
    
  
  }
  public class ControlPlaneNested<N> extends MachinePoolFluent<ControlPlaneNested<N>> implements Nested<N>{
    ControlPlaneNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withControlPlane(builder.build());
    }
    
    public N endControlPlane() {
      return and();
    }
    
  
  }
  public class ImageContentSourcesNested<N> extends ImageContentSourceFluent<ImageContentSourcesNested<N>> implements Nested<N>{
    ImageContentSourcesNested(int index,ImageContentSource item) {
      this.index = index;
      this.builder = new ImageContentSourceBuilder(this, item);
    }
    ImageContentSourceBuilder builder;
    int index;
    
    public N and() {
      return (N) InstallConfigFluent.this.setToImageContentSources(index,builder.build());
    }
    
    public N endImageContentSource() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class NetworkingNested<N> extends NetworkingFluent<NetworkingNested<N>> implements Nested<N>{
    NetworkingNested(Networking item) {
      this.builder = new NetworkingBuilder(this, item);
    }
    NetworkingBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withNetworking(builder.build());
    }
    
    public N endNetworking() {
      return and();
    }
    
  
  }
  public class PlatformNested<N> extends PlatformFluent<PlatformNested<N>> implements Nested<N>{
    PlatformNested(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withPlatform(builder.build());
    }
    
    public N endPlatform() {
      return and();
    }
    
  
  }
  public class ProxyNested<N> extends ProxyFluent<ProxyNested<N>> implements Nested<N>{
    ProxyNested(Proxy item) {
      this.builder = new ProxyBuilder(this, item);
    }
    ProxyBuilder builder;
    
    public N and() {
      return (N) InstallConfigFluent.this.withProxy(builder.build());
    }
    
    public N endProxy() {
      return and();
    }
    
  
  }

}