package io.fabric8.openshift.api.model.installer.vsphere.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TopologyFluent<A extends TopologyFluent<A>> extends BaseFluent<A>{
  public TopologyFluent() {
  }
  
  public TopologyFluent(Topology instance) {
    this.copyInstance(instance);
  }
  private String computeCluster;
  private String datacenter;
  private String datastore;
  private String folder;
  private List<String> networks = new ArrayList<String>();
  private String resourcePool;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Topology instance) {
    instance = (instance != null ? instance : new Topology());
    if (instance != null) {
          this.withComputeCluster(instance.getComputeCluster());
          this.withDatacenter(instance.getDatacenter());
          this.withDatastore(instance.getDatastore());
          this.withFolder(instance.getFolder());
          this.withNetworks(instance.getNetworks());
          this.withResourcePool(instance.getResourcePool());
          this.withComputeCluster(instance.getComputeCluster());
          this.withDatacenter(instance.getDatacenter());
          this.withDatastore(instance.getDatastore());
          this.withFolder(instance.getFolder());
          this.withNetworks(instance.getNetworks());
          this.withResourcePool(instance.getResourcePool());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getComputeCluster() {
    return this.computeCluster;
  }
  
  public A withComputeCluster(String computeCluster) {
    this.computeCluster = computeCluster;
    return (A) this;
  }
  
  public boolean hasComputeCluster() {
    return this.computeCluster != null;
  }
  
  public String getDatacenter() {
    return this.datacenter;
  }
  
  public A withDatacenter(String datacenter) {
    this.datacenter = datacenter;
    return (A) this;
  }
  
  public boolean hasDatacenter() {
    return this.datacenter != null;
  }
  
  public String getDatastore() {
    return this.datastore;
  }
  
  public A withDatastore(String datastore) {
    this.datastore = datastore;
    return (A) this;
  }
  
  public boolean hasDatastore() {
    return this.datastore != null;
  }
  
  public String getFolder() {
    return this.folder;
  }
  
  public A withFolder(String folder) {
    this.folder = folder;
    return (A) this;
  }
  
  public boolean hasFolder() {
    return this.folder != null;
  }
  
  public A addToNetworks(int index,String item) {
    if (this.networks == null) {this.networks = new ArrayList<String>();}
    this.networks.add(index, item);
    return (A)this;
  }
  
  public A setToNetworks(int index,String item) {
    if (this.networks == null) {this.networks = new ArrayList<String>();}
    this.networks.set(index, item); return (A)this;
  }
  
  public A addToNetworks(java.lang.String... items) {
    if (this.networks == null) {this.networks = new ArrayList<String>();}
    for (String item : items) {this.networks.add(item);} return (A)this;
  }
  
  public A addAllToNetworks(Collection<String> items) {
    if (this.networks == null) {this.networks = new ArrayList<String>();}
    for (String item : items) {this.networks.add(item);} return (A)this;
  }
  
  public A removeFromNetworks(java.lang.String... items) {
    if (this.networks == null) return (A)this;
    for (String item : items) { this.networks.remove(item);} return (A)this;
  }
  
  public A removeAllFromNetworks(Collection<String> items) {
    if (this.networks == null) return (A)this;
    for (String item : items) { this.networks.remove(item);} return (A)this;
  }
  
  public List<String> getNetworks() {
    return this.networks;
  }
  
  public String getNetwork(int index) {
    return this.networks.get(index);
  }
  
  public String getFirstNetwork() {
    return this.networks.get(0);
  }
  
  public String getLastNetwork() {
    return this.networks.get(networks.size() - 1);
  }
  
  public String getMatchingNetwork(Predicate<String> predicate) {
      for (String item : networks) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingNetwork(Predicate<String> predicate) {
      for (String item : networks) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNetworks(List<String> networks) {
    if (networks != null) {
        this.networks = new ArrayList();
        for (String item : networks) {
          this.addToNetworks(item);
        }
    } else {
      this.networks = null;
    }
    return (A) this;
  }
  
  public A withNetworks(java.lang.String... networks) {
    if (this.networks != null) {this.networks.clear(); _visitables.remove("networks"); }
    if (networks != null) {for (String item :networks){ this.addToNetworks(item);}} return (A) this;
  }
  
  public boolean hasNetworks() {
    return this.networks != null && !this.networks.isEmpty();
  }
  
  public String getResourcePool() {
    return this.resourcePool;
  }
  
  public A withResourcePool(String resourcePool) {
    this.resourcePool = resourcePool;
    return (A) this;
  }
  
  public boolean hasResourcePool() {
    return this.resourcePool != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TopologyFluent that = (TopologyFluent) o;
    if (!java.util.Objects.equals(computeCluster, that.computeCluster)) return false;
    if (!java.util.Objects.equals(datacenter, that.datacenter)) return false;
    if (!java.util.Objects.equals(datastore, that.datastore)) return false;
    if (!java.util.Objects.equals(folder, that.folder)) return false;
    if (!java.util.Objects.equals(networks, that.networks)) return false;
    if (!java.util.Objects.equals(resourcePool, that.resourcePool)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(computeCluster,  datacenter,  datastore,  folder,  networks,  resourcePool,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeCluster != null) { sb.append("computeCluster:"); sb.append(computeCluster + ","); }
    if (datacenter != null) { sb.append("datacenter:"); sb.append(datacenter + ","); }
    if (datastore != null) { sb.append("datastore:"); sb.append(datastore + ","); }
    if (folder != null) { sb.append("folder:"); sb.append(folder + ","); }
    if (networks != null && !networks.isEmpty()) { sb.append("networks:"); sb.append(networks + ","); }
    if (resourcePool != null) { sb.append("resourcePool:"); sb.append(resourcePool + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}