package io.fabric8.openshift.api.model.installer.azure.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfidentialVMBuilder extends ConfidentialVMFluent<ConfidentialVMBuilder> implements VisitableBuilder<ConfidentialVM,ConfidentialVMBuilder>{
  public ConfidentialVMBuilder() {
    this(new ConfidentialVM());
  }
  
  public ConfidentialVMBuilder(ConfidentialVMFluent<?> fluent) {
    this(fluent, new ConfidentialVM());
  }
  
  public ConfidentialVMBuilder(ConfidentialVMFluent<?> fluent,ConfidentialVM instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfidentialVMBuilder(ConfidentialVM instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfidentialVMFluent<?> fluent;
  
  public ConfidentialVM build() {
    ConfidentialVM buildable = new ConfidentialVM(fluent.buildUefiSettings());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}