package io.fabric8.openshift.api.model.installer.azure.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachinePoolFluent<A extends MachinePoolFluent<A>> extends BaseFluent<A>{
  public MachinePoolFluent() {
  }
  
  public MachinePoolFluent(MachinePool instance) {
    this.copyInstance(instance);
  }
  private Boolean encryptionAtHost;
  private OSDiskBuilder osDisk;
  private OSImageBuilder osImage;
  private SecuritySettingsBuilder settings;
  private String type;
  private String ultraSSDCapability;
  private String vmNetworkingType;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachinePool instance) {
    instance = (instance != null ? instance : new MachinePool());
    if (instance != null) {
          this.withEncryptionAtHost(instance.getEncryptionAtHost());
          this.withOsDisk(instance.getOsDisk());
          this.withOsImage(instance.getOsImage());
          this.withSettings(instance.getSettings());
          this.withType(instance.getType());
          this.withUltraSSDCapability(instance.getUltraSSDCapability());
          this.withVmNetworkingType(instance.getVmNetworkingType());
          this.withZones(instance.getZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Boolean getEncryptionAtHost() {
    return this.encryptionAtHost;
  }
  
  public A withEncryptionAtHost(Boolean encryptionAtHost) {
    this.encryptionAtHost = encryptionAtHost;
    return (A) this;
  }
  
  public boolean hasEncryptionAtHost() {
    return this.encryptionAtHost != null;
  }
  
  public OSDisk buildOsDisk() {
    return this.osDisk != null ? this.osDisk.build() : null;
  }
  
  public A withOsDisk(OSDisk osDisk) {
    this._visitables.remove("osDisk");
    if (osDisk != null) {
        this.osDisk = new OSDiskBuilder(osDisk);
        this._visitables.get("osDisk").add(this.osDisk);
    } else {
        this.osDisk = null;
        this._visitables.get("osDisk").remove(this.osDisk);
    }
    return (A) this;
  }
  
  public boolean hasOsDisk() {
    return this.osDisk != null;
  }
  
  public OsDiskNested<A> withNewOsDisk() {
    return new OsDiskNested(null);
  }
  
  public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
    return new OsDiskNested(item);
  }
  
  public OsDiskNested<A> editOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(null));
  }
  
  public OsDiskNested<A> editOrNewOsDisk() {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(new OSDiskBuilder().build()));
  }
  
  public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
    return withNewOsDiskLike(java.util.Optional.ofNullable(buildOsDisk()).orElse(item));
  }
  
  public OSImage buildOsImage() {
    return this.osImage != null ? this.osImage.build() : null;
  }
  
  public A withOsImage(OSImage osImage) {
    this._visitables.remove("osImage");
    if (osImage != null) {
        this.osImage = new OSImageBuilder(osImage);
        this._visitables.get("osImage").add(this.osImage);
    } else {
        this.osImage = null;
        this._visitables.get("osImage").remove(this.osImage);
    }
    return (A) this;
  }
  
  public boolean hasOsImage() {
    return this.osImage != null;
  }
  
  public A withNewOsImage(String offer,String plan,String publisher,String sku,String version) {
    return (A)withOsImage(new OSImage(offer, plan, publisher, sku, version));
  }
  
  public OsImageNested<A> withNewOsImage() {
    return new OsImageNested(null);
  }
  
  public OsImageNested<A> withNewOsImageLike(OSImage item) {
    return new OsImageNested(item);
  }
  
  public OsImageNested<A> editOsImage() {
    return withNewOsImageLike(java.util.Optional.ofNullable(buildOsImage()).orElse(null));
  }
  
  public OsImageNested<A> editOrNewOsImage() {
    return withNewOsImageLike(java.util.Optional.ofNullable(buildOsImage()).orElse(new OSImageBuilder().build()));
  }
  
  public OsImageNested<A> editOrNewOsImageLike(OSImage item) {
    return withNewOsImageLike(java.util.Optional.ofNullable(buildOsImage()).orElse(item));
  }
  
  public SecuritySettings buildSettings() {
    return this.settings != null ? this.settings.build() : null;
  }
  
  public A withSettings(SecuritySettings settings) {
    this._visitables.remove("settings");
    if (settings != null) {
        this.settings = new SecuritySettingsBuilder(settings);
        this._visitables.get("settings").add(this.settings);
    } else {
        this.settings = null;
        this._visitables.get("settings").remove(this.settings);
    }
    return (A) this;
  }
  
  public boolean hasSettings() {
    return this.settings != null;
  }
  
  public SettingsNested<A> withNewSettings() {
    return new SettingsNested(null);
  }
  
  public SettingsNested<A> withNewSettingsLike(SecuritySettings item) {
    return new SettingsNested(item);
  }
  
  public SettingsNested<A> editSettings() {
    return withNewSettingsLike(java.util.Optional.ofNullable(buildSettings()).orElse(null));
  }
  
  public SettingsNested<A> editOrNewSettings() {
    return withNewSettingsLike(java.util.Optional.ofNullable(buildSettings()).orElse(new SecuritySettingsBuilder().build()));
  }
  
  public SettingsNested<A> editOrNewSettingsLike(SecuritySettings item) {
    return withNewSettingsLike(java.util.Optional.ofNullable(buildSettings()).orElse(item));
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public String getUltraSSDCapability() {
    return this.ultraSSDCapability;
  }
  
  public A withUltraSSDCapability(String ultraSSDCapability) {
    this.ultraSSDCapability = ultraSSDCapability;
    return (A) this;
  }
  
  public boolean hasUltraSSDCapability() {
    return this.ultraSSDCapability != null;
  }
  
  public String getVmNetworkingType() {
    return this.vmNetworkingType;
  }
  
  public A withVmNetworkingType(String vmNetworkingType) {
    this.vmNetworkingType = vmNetworkingType;
    return (A) this;
  }
  
  public boolean hasVmNetworkingType() {
    return this.vmNetworkingType != null;
  }
  
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public List<String> getZones() {
    return this.zones;
  }
  
  public String getZone(int index) {
    return this.zones.get(index);
  }
  
  public String getFirstZone() {
    return this.zones.get(0);
  }
  
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  
  public String getMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withZones(List<String> zones) {
    if (zones != null) {
        this.zones = new ArrayList();
        for (String item : zones) {
          this.addToZones(item);
        }
    } else {
      this.zones = null;
    }
    return (A) this;
  }
  
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {
        this.zones.clear();
        _visitables.remove("zones");
    }
    if (zones != null) {
      for (String item : zones) {
        this.addToZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasZones() {
    return this.zones != null && !this.zones.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolFluent that = (MachinePoolFluent) o;
    if (!java.util.Objects.equals(encryptionAtHost, that.encryptionAtHost)) return false;
    if (!java.util.Objects.equals(osDisk, that.osDisk)) return false;
    if (!java.util.Objects.equals(osImage, that.osImage)) return false;
    if (!java.util.Objects.equals(settings, that.settings)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(ultraSSDCapability, that.ultraSSDCapability)) return false;
    if (!java.util.Objects.equals(vmNetworkingType, that.vmNetworkingType)) return false;
    if (!java.util.Objects.equals(zones, that.zones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(encryptionAtHost,  osDisk,  osImage,  settings,  type,  ultraSSDCapability,  vmNetworkingType,  zones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (encryptionAtHost != null) { sb.append("encryptionAtHost:"); sb.append(encryptionAtHost + ","); }
    if (osDisk != null) { sb.append("osDisk:"); sb.append(osDisk + ","); }
    if (osImage != null) { sb.append("osImage:"); sb.append(osImage + ","); }
    if (settings != null) { sb.append("settings:"); sb.append(settings + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (ultraSSDCapability != null) { sb.append("ultraSSDCapability:"); sb.append(ultraSSDCapability + ","); }
    if (vmNetworkingType != null) { sb.append("vmNetworkingType:"); sb.append(vmNetworkingType + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withEncryptionAtHost() {
    return withEncryptionAtHost(true);
  }
  public class OsDiskNested<N> extends OSDiskFluent<OsDiskNested<N>> implements Nested<N>{
    OsDiskNested(OSDisk item) {
      this.builder = new OSDiskBuilder(this, item);
    }
    OSDiskBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withOsDisk(builder.build());
    }
    
    public N endOsDisk() {
      return and();
    }
    
  
  }
  public class OsImageNested<N> extends OSImageFluent<OsImageNested<N>> implements Nested<N>{
    OsImageNested(OSImage item) {
      this.builder = new OSImageBuilder(this, item);
    }
    OSImageBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withOsImage(builder.build());
    }
    
    public N endOsImage() {
      return and();
    }
    
  
  }
  public class SettingsNested<N> extends SecuritySettingsFluent<SettingsNested<N>> implements Nested<N>{
    SettingsNested(SecuritySettings item) {
      this.builder = new SecuritySettingsBuilder(this, item);
    }
    SecuritySettingsBuilder builder;
    
    public N and() {
      return (N) MachinePoolFluent.this.withSettings(builder.build());
    }
    
    public N endSettings() {
      return and();
    }
    
  
  }

}