package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PlatformFluent<A extends PlatformFluent<A>> extends BaseFluent<A>{
  public PlatformFluent() {
  }
  
  public PlatformFluent(Platform instance) {
    this.copyInstance(instance);
  }
  private String computeSubnet;
  private String controlPlaneSubnet;
  private MachinePoolBuilder defaultMachinePlatform;
  private String network;
  private String networkProjectID;
  private String projectID;
  private String region;
  private ArrayList<UserLabelBuilder> userLabels = new ArrayList<UserLabelBuilder>();
  private String userProvisionedDNS;
  private ArrayList<UserTagBuilder> userTags = new ArrayList<UserTagBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Platform instance) {
    instance = (instance != null ? instance : new Platform());
    if (instance != null) {
          this.withComputeSubnet(instance.getComputeSubnet());
          this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
          this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
          this.withNetwork(instance.getNetwork());
          this.withNetworkProjectID(instance.getNetworkProjectID());
          this.withProjectID(instance.getProjectID());
          this.withRegion(instance.getRegion());
          this.withUserLabels(instance.getUserLabels());
          this.withUserProvisionedDNS(instance.getUserProvisionedDNS());
          this.withUserTags(instance.getUserTags());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getComputeSubnet() {
    return this.computeSubnet;
  }
  
  public A withComputeSubnet(String computeSubnet) {
    this.computeSubnet = computeSubnet;
    return (A) this;
  }
  
  public boolean hasComputeSubnet() {
    return this.computeSubnet != null;
  }
  
  public String getControlPlaneSubnet() {
    return this.controlPlaneSubnet;
  }
  
  public A withControlPlaneSubnet(String controlPlaneSubnet) {
    this.controlPlaneSubnet = controlPlaneSubnet;
    return (A) this;
  }
  
  public boolean hasControlPlaneSubnet() {
    return this.controlPlaneSubnet != null;
  }
  
  public MachinePool buildDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
  }
  
  public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
    this._visitables.remove("defaultMachinePlatform");
    if (defaultMachinePlatform != null) {
        this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
        this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
    } else {
        this.defaultMachinePlatform = null;
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
    }
    return (A) this;
  }
  
  public boolean hasDefaultMachinePlatform() {
    return this.defaultMachinePlatform != null;
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
    return new DefaultMachinePlatformNested(null);
  }
  
  public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
    return new DefaultMachinePlatformNested(item);
  }
  
  public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(null));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
  }
  
  public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
    return withNewDefaultMachinePlatformLike(java.util.Optional.ofNullable(buildDefaultMachinePlatform()).orElse(item));
  }
  
  public String getNetwork() {
    return this.network;
  }
  
  public A withNetwork(String network) {
    this.network = network;
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public String getNetworkProjectID() {
    return this.networkProjectID;
  }
  
  public A withNetworkProjectID(String networkProjectID) {
    this.networkProjectID = networkProjectID;
    return (A) this;
  }
  
  public boolean hasNetworkProjectID() {
    return this.networkProjectID != null;
  }
  
  public String getProjectID() {
    return this.projectID;
  }
  
  public A withProjectID(String projectID) {
    this.projectID = projectID;
    return (A) this;
  }
  
  public boolean hasProjectID() {
    return this.projectID != null;
  }
  
  public String getRegion() {
    return this.region;
  }
  
  public A withRegion(String region) {
    this.region = region;
    return (A) this;
  }
  
  public boolean hasRegion() {
    return this.region != null;
  }
  
  public A addToUserLabels(int index,UserLabel item) {
    if (this.userLabels == null) {this.userLabels = new ArrayList<UserLabelBuilder>();}
    UserLabelBuilder builder = new UserLabelBuilder(item);
    if (index < 0 || index >= userLabels.size()) {
        _visitables.get("userLabels").add(builder);
        userLabels.add(builder);
    } else {
        _visitables.get("userLabels").add(builder);
        userLabels.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToUserLabels(int index,UserLabel item) {
    if (this.userLabels == null) {this.userLabels = new ArrayList<UserLabelBuilder>();}
    UserLabelBuilder builder = new UserLabelBuilder(item);
    if (index < 0 || index >= userLabels.size()) {
        _visitables.get("userLabels").add(builder);
        userLabels.add(builder);
    } else {
        _visitables.get("userLabels").add(builder);
        userLabels.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToUserLabels(io.fabric8.openshift.api.model.installer.gcp.v1.UserLabel... items) {
    if (this.userLabels == null) {this.userLabels = new ArrayList<UserLabelBuilder>();}
    for (UserLabel item : items) {UserLabelBuilder builder = new UserLabelBuilder(item);_visitables.get("userLabels").add(builder);this.userLabels.add(builder);} return (A)this;
  }
  
  public A addAllToUserLabels(Collection<UserLabel> items) {
    if (this.userLabels == null) {this.userLabels = new ArrayList<UserLabelBuilder>();}
    for (UserLabel item : items) {UserLabelBuilder builder = new UserLabelBuilder(item);_visitables.get("userLabels").add(builder);this.userLabels.add(builder);} return (A)this;
  }
  
  public A removeFromUserLabels(io.fabric8.openshift.api.model.installer.gcp.v1.UserLabel... items) {
    if (this.userLabels == null) return (A)this;
    for (UserLabel item : items) {UserLabelBuilder builder = new UserLabelBuilder(item);_visitables.get("userLabels").remove(builder); this.userLabels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromUserLabels(Collection<UserLabel> items) {
    if (this.userLabels == null) return (A)this;
    for (UserLabel item : items) {UserLabelBuilder builder = new UserLabelBuilder(item);_visitables.get("userLabels").remove(builder); this.userLabels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromUserLabels(Predicate<UserLabelBuilder> predicate) {
    if (userLabels == null) return (A) this;
    final Iterator<UserLabelBuilder> each = userLabels.iterator();
    final List visitables = _visitables.get("userLabels");
    while (each.hasNext()) {
      UserLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<UserLabel> buildUserLabels() {
    return this.userLabels != null ? build(userLabels) : null;
  }
  
  public UserLabel buildUserLabel(int index) {
    return this.userLabels.get(index).build();
  }
  
  public UserLabel buildFirstUserLabel() {
    return this.userLabels.get(0).build();
  }
  
  public UserLabel buildLastUserLabel() {
    return this.userLabels.get(userLabels.size() - 1).build();
  }
  
  public UserLabel buildMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
      for (UserLabelBuilder item : userLabels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
      for (UserLabelBuilder item : userLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUserLabels(List<UserLabel> userLabels) {
    if (this.userLabels != null) {
      this._visitables.get("userLabels").clear();
    }
    if (userLabels != null) {
        this.userLabels = new ArrayList();
        for (UserLabel item : userLabels) {
          this.addToUserLabels(item);
        }
    } else {
      this.userLabels = null;
    }
    return (A) this;
  }
  
  public A withUserLabels(io.fabric8.openshift.api.model.installer.gcp.v1.UserLabel... userLabels) {
    if (this.userLabels != null) {
        this.userLabels.clear();
        _visitables.remove("userLabels");
    }
    if (userLabels != null) {
      for (UserLabel item : userLabels) {
        this.addToUserLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUserLabels() {
    return this.userLabels != null && !this.userLabels.isEmpty();
  }
  
  public A addNewUserLabel(String key,String value) {
    return (A)addToUserLabels(new UserLabel(key, value));
  }
  
  public UserLabelsNested<A> addNewUserLabel() {
    return new UserLabelsNested(-1, null);
  }
  
  public UserLabelsNested<A> addNewUserLabelLike(UserLabel item) {
    return new UserLabelsNested(-1, item);
  }
  
  public UserLabelsNested<A> setNewUserLabelLike(int index,UserLabel item) {
    return new UserLabelsNested(index, item);
  }
  
  public UserLabelsNested<A> editUserLabel(int index) {
    if (userLabels.size() <= index) throw new RuntimeException("Can't edit userLabels. Index exceeds size.");
    return setNewUserLabelLike(index, buildUserLabel(index));
  }
  
  public UserLabelsNested<A> editFirstUserLabel() {
    if (userLabels.size() == 0) throw new RuntimeException("Can't edit first userLabels. The list is empty.");
    return setNewUserLabelLike(0, buildUserLabel(0));
  }
  
  public UserLabelsNested<A> editLastUserLabel() {
    int index = userLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last userLabels. The list is empty.");
    return setNewUserLabelLike(index, buildUserLabel(index));
  }
  
  public UserLabelsNested<A> editMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<userLabels.size();i++) { 
    if (predicate.test(userLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching userLabels. No match found.");
    return setNewUserLabelLike(index, buildUserLabel(index));
  }
  
  public String getUserProvisionedDNS() {
    return this.userProvisionedDNS;
  }
  
  public A withUserProvisionedDNS(String userProvisionedDNS) {
    this.userProvisionedDNS = userProvisionedDNS;
    return (A) this;
  }
  
  public boolean hasUserProvisionedDNS() {
    return this.userProvisionedDNS != null;
  }
  
  public A addToUserTags(int index,UserTag item) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    UserTagBuilder builder = new UserTagBuilder(item);
    if (index < 0 || index >= userTags.size()) {
        _visitables.get("userTags").add(builder);
        userTags.add(builder);
    } else {
        _visitables.get("userTags").add(builder);
        userTags.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToUserTags(int index,UserTag item) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    UserTagBuilder builder = new UserTagBuilder(item);
    if (index < 0 || index >= userTags.size()) {
        _visitables.get("userTags").add(builder);
        userTags.add(builder);
    } else {
        _visitables.get("userTags").add(builder);
        userTags.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToUserTags(io.fabric8.openshift.api.model.installer.gcp.v1.UserTag... items) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").add(builder);this.userTags.add(builder);} return (A)this;
  }
  
  public A addAllToUserTags(Collection<UserTag> items) {
    if (this.userTags == null) {this.userTags = new ArrayList<UserTagBuilder>();}
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").add(builder);this.userTags.add(builder);} return (A)this;
  }
  
  public A removeFromUserTags(io.fabric8.openshift.api.model.installer.gcp.v1.UserTag... items) {
    if (this.userTags == null) return (A)this;
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").remove(builder); this.userTags.remove(builder);} return (A)this;
  }
  
  public A removeAllFromUserTags(Collection<UserTag> items) {
    if (this.userTags == null) return (A)this;
    for (UserTag item : items) {UserTagBuilder builder = new UserTagBuilder(item);_visitables.get("userTags").remove(builder); this.userTags.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromUserTags(Predicate<UserTagBuilder> predicate) {
    if (userTags == null) return (A) this;
    final Iterator<UserTagBuilder> each = userTags.iterator();
    final List visitables = _visitables.get("userTags");
    while (each.hasNext()) {
      UserTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<UserTag> buildUserTags() {
    return this.userTags != null ? build(userTags) : null;
  }
  
  public UserTag buildUserTag(int index) {
    return this.userTags.get(index).build();
  }
  
  public UserTag buildFirstUserTag() {
    return this.userTags.get(0).build();
  }
  
  public UserTag buildLastUserTag() {
    return this.userTags.get(userTags.size() - 1).build();
  }
  
  public UserTag buildMatchingUserTag(Predicate<UserTagBuilder> predicate) {
      for (UserTagBuilder item : userTags) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingUserTag(Predicate<UserTagBuilder> predicate) {
      for (UserTagBuilder item : userTags) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withUserTags(List<UserTag> userTags) {
    if (this.userTags != null) {
      this._visitables.get("userTags").clear();
    }
    if (userTags != null) {
        this.userTags = new ArrayList();
        for (UserTag item : userTags) {
          this.addToUserTags(item);
        }
    } else {
      this.userTags = null;
    }
    return (A) this;
  }
  
  public A withUserTags(io.fabric8.openshift.api.model.installer.gcp.v1.UserTag... userTags) {
    if (this.userTags != null) {
        this.userTags.clear();
        _visitables.remove("userTags");
    }
    if (userTags != null) {
      for (UserTag item : userTags) {
        this.addToUserTags(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasUserTags() {
    return this.userTags != null && !this.userTags.isEmpty();
  }
  
  public A addNewUserTag(String key,String parentID,String value) {
    return (A)addToUserTags(new UserTag(key, parentID, value));
  }
  
  public UserTagsNested<A> addNewUserTag() {
    return new UserTagsNested(-1, null);
  }
  
  public UserTagsNested<A> addNewUserTagLike(UserTag item) {
    return new UserTagsNested(-1, item);
  }
  
  public UserTagsNested<A> setNewUserTagLike(int index,UserTag item) {
    return new UserTagsNested(index, item);
  }
  
  public UserTagsNested<A> editUserTag(int index) {
    if (userTags.size() <= index) throw new RuntimeException("Can't edit userTags. Index exceeds size.");
    return setNewUserTagLike(index, buildUserTag(index));
  }
  
  public UserTagsNested<A> editFirstUserTag() {
    if (userTags.size() == 0) throw new RuntimeException("Can't edit first userTags. The list is empty.");
    return setNewUserTagLike(0, buildUserTag(0));
  }
  
  public UserTagsNested<A> editLastUserTag() {
    int index = userTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last userTags. The list is empty.");
    return setNewUserTagLike(index, buildUserTag(index));
  }
  
  public UserTagsNested<A> editMatchingUserTag(Predicate<UserTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<userTags.size();i++) { 
    if (predicate.test(userTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching userTags. No match found.");
    return setNewUserTagLike(index, buildUserTag(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformFluent that = (PlatformFluent) o;
    if (!java.util.Objects.equals(computeSubnet, that.computeSubnet)) return false;
    if (!java.util.Objects.equals(controlPlaneSubnet, that.controlPlaneSubnet)) return false;
    if (!java.util.Objects.equals(defaultMachinePlatform, that.defaultMachinePlatform)) return false;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(networkProjectID, that.networkProjectID)) return false;
    if (!java.util.Objects.equals(projectID, that.projectID)) return false;
    if (!java.util.Objects.equals(region, that.region)) return false;
    if (!java.util.Objects.equals(userLabels, that.userLabels)) return false;
    if (!java.util.Objects.equals(userProvisionedDNS, that.userProvisionedDNS)) return false;
    if (!java.util.Objects.equals(userTags, that.userTags)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(computeSubnet,  controlPlaneSubnet,  defaultMachinePlatform,  network,  networkProjectID,  projectID,  region,  userLabels,  userProvisionedDNS,  userTags,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeSubnet != null) { sb.append("computeSubnet:"); sb.append(computeSubnet + ","); }
    if (controlPlaneSubnet != null) { sb.append("controlPlaneSubnet:"); sb.append(controlPlaneSubnet + ","); }
    if (defaultMachinePlatform != null) { sb.append("defaultMachinePlatform:"); sb.append(defaultMachinePlatform + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (networkProjectID != null) { sb.append("networkProjectID:"); sb.append(networkProjectID + ","); }
    if (projectID != null) { sb.append("projectID:"); sb.append(projectID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (userLabels != null && !userLabels.isEmpty()) { sb.append("userLabels:"); sb.append(userLabels + ","); }
    if (userProvisionedDNS != null) { sb.append("userProvisionedDNS:"); sb.append(userProvisionedDNS + ","); }
    if (userTags != null && !userTags.isEmpty()) { sb.append("userTags:"); sb.append(userTags + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DefaultMachinePlatformNested<N> extends MachinePoolFluent<DefaultMachinePlatformNested<N>> implements Nested<N>{
    DefaultMachinePlatformNested(MachinePool item) {
      this.builder = new MachinePoolBuilder(this, item);
    }
    MachinePoolBuilder builder;
    
    public N and() {
      return (N) PlatformFluent.this.withDefaultMachinePlatform(builder.build());
    }
    
    public N endDefaultMachinePlatform() {
      return and();
    }
    
  
  }
  public class UserLabelsNested<N> extends UserLabelFluent<UserLabelsNested<N>> implements Nested<N>{
    UserLabelsNested(int index,UserLabel item) {
      this.index = index;
      this.builder = new UserLabelBuilder(this, item);
    }
    UserLabelBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToUserLabels(index,builder.build());
    }
    
    public N endUserLabel() {
      return and();
    }
    
  
  }
  public class UserTagsNested<N> extends UserTagFluent<UserTagsNested<N>> implements Nested<N>{
    UserTagsNested(int index,UserTag item) {
      this.index = index;
      this.builder = new UserTagBuilder(this, item);
    }
    UserTagBuilder builder;
    int index;
    
    public N and() {
      return (N) PlatformFluent.this.setToUserTags(index,builder.build());
    }
    
    public N endUserTag() {
      return and();
    }
    
  
  }

}