package io.fabric8.openshift.api.model.installer.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QuotaUsageFluent<A extends QuotaUsageFluent<A>> extends BaseFluent<A>{
  public QuotaUsageFluent() {
  }
  
  public QuotaUsageFluent(QuotaUsage instance) {
    this.copyInstance(instance);
  }
  private Long amount;
  private Map<String,String> dimensions;
  private String limit;
  private String service;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(QuotaUsage instance) {
    instance = (instance != null ? instance : new QuotaUsage());
    if (instance != null) {
          this.withAmount(instance.getAmount());
          this.withDimensions(instance.getDimensions());
          this.withLimit(instance.getLimit());
          this.withService(instance.getService());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getAmount() {
    return this.amount;
  }
  
  public A withAmount(Long amount) {
    this.amount = amount;
    return (A) this;
  }
  
  public boolean hasAmount() {
    return this.amount != null;
  }
  
  public A addToDimensions(String key,String value) {
    if(this.dimensions == null && key != null && value != null) { this.dimensions = new LinkedHashMap(); }
    if(key != null && value != null) {this.dimensions.put(key, value);} return (A)this;
  }
  
  public A addToDimensions(Map<String,String> map) {
    if(this.dimensions == null && map != null) { this.dimensions = new LinkedHashMap(); }
    if(map != null) { this.dimensions.putAll(map);} return (A)this;
  }
  
  public A removeFromDimensions(String key) {
    if(this.dimensions == null) { return (A) this; }
    if(key != null && this.dimensions != null) {this.dimensions.remove(key);} return (A)this;
  }
  
  public A removeFromDimensions(Map<String,String> map) {
    if(this.dimensions == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.dimensions != null){this.dimensions.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getDimensions() {
    return this.dimensions;
  }
  
  public <K,V>A withDimensions(Map<String,String> dimensions) {
    if (dimensions == null) {
      this.dimensions = null;
    } else {
      this.dimensions = new LinkedHashMap(dimensions);
    }
    return (A) this;
  }
  
  public boolean hasDimensions() {
    return this.dimensions != null;
  }
  
  public String getLimit() {
    return this.limit;
  }
  
  public A withLimit(String limit) {
    this.limit = limit;
    return (A) this;
  }
  
  public boolean hasLimit() {
    return this.limit != null;
  }
  
  public String getService() {
    return this.service;
  }
  
  public A withService(String service) {
    this.service = service;
    return (A) this;
  }
  
  public boolean hasService() {
    return this.service != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QuotaUsageFluent that = (QuotaUsageFluent) o;
    if (!java.util.Objects.equals(amount, that.amount)) return false;
    if (!java.util.Objects.equals(dimensions, that.dimensions)) return false;
    if (!java.util.Objects.equals(limit, that.limit)) return false;
    if (!java.util.Objects.equals(service, that.service)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(amount,  dimensions,  limit,  service,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (amount != null) { sb.append("amount:"); sb.append(amount + ","); }
    if (dimensions != null && !dimensions.isEmpty()) { sb.append("dimensions:"); sb.append(dimensions + ","); }
    if (limit != null) { sb.append("limit:"); sb.append(limit + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}