package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.openshift.api.model.machine.v1.NutanixVMDiskDeviceProperties;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DataDiskFluent<A extends DataDiskFluent<A>> extends BaseFluent<A>{
  public DataDiskFluent() {
  }
  
  public DataDiskFluent(DataDisk instance) {
    this.copyInstance(instance);
  }
  private StorageResourceReferenceBuilder dataSourceImage;
  private NutanixVMDiskDeviceProperties deviceProperties;
  private Quantity diskSize;
  private StorageConfigBuilder storageConfig;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DataDisk instance) {
    instance = (instance != null ? instance : new DataDisk());
    if (instance != null) {
          this.withDataSourceImage(instance.getDataSourceImage());
          this.withDeviceProperties(instance.getDeviceProperties());
          this.withDiskSize(instance.getDiskSize());
          this.withStorageConfig(instance.getStorageConfig());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public StorageResourceReference buildDataSourceImage() {
    return this.dataSourceImage != null ? this.dataSourceImage.build() : null;
  }
  
  public A withDataSourceImage(StorageResourceReference dataSourceImage) {
    this._visitables.remove("dataSourceImage");
    if (dataSourceImage != null) {
        this.dataSourceImage = new StorageResourceReferenceBuilder(dataSourceImage);
        this._visitables.get("dataSourceImage").add(this.dataSourceImage);
    } else {
        this.dataSourceImage = null;
        this._visitables.get("dataSourceImage").remove(this.dataSourceImage);
    }
    return (A) this;
  }
  
  public boolean hasDataSourceImage() {
    return this.dataSourceImage != null;
  }
  
  public A withNewDataSourceImage(String name,String referenceName,String uuid) {
    return (A)withDataSourceImage(new StorageResourceReference(name, referenceName, uuid));
  }
  
  public DataSourceImageNested<A> withNewDataSourceImage() {
    return new DataSourceImageNested(null);
  }
  
  public DataSourceImageNested<A> withNewDataSourceImageLike(StorageResourceReference item) {
    return new DataSourceImageNested(item);
  }
  
  public DataSourceImageNested<A> editDataSourceImage() {
    return withNewDataSourceImageLike(java.util.Optional.ofNullable(buildDataSourceImage()).orElse(null));
  }
  
  public DataSourceImageNested<A> editOrNewDataSourceImage() {
    return withNewDataSourceImageLike(java.util.Optional.ofNullable(buildDataSourceImage()).orElse(new StorageResourceReferenceBuilder().build()));
  }
  
  public DataSourceImageNested<A> editOrNewDataSourceImageLike(StorageResourceReference item) {
    return withNewDataSourceImageLike(java.util.Optional.ofNullable(buildDataSourceImage()).orElse(item));
  }
  
  public NutanixVMDiskDeviceProperties getDeviceProperties() {
    return this.deviceProperties;
  }
  
  public A withDeviceProperties(NutanixVMDiskDeviceProperties deviceProperties) {
    this.deviceProperties = deviceProperties;
    return (A) this;
  }
  
  public boolean hasDeviceProperties() {
    return this.deviceProperties != null;
  }
  
  public A withNewDeviceProperties(String adapterType,Integer deviceIndex,String deviceType) {
    return (A)withDeviceProperties(new NutanixVMDiskDeviceProperties(adapterType, deviceIndex, deviceType));
  }
  
  public Quantity getDiskSize() {
    return this.diskSize;
  }
  
  public A withDiskSize(Quantity diskSize) {
    this.diskSize = diskSize;
    return (A) this;
  }
  
  public boolean hasDiskSize() {
    return this.diskSize != null;
  }
  
  public A withNewDiskSize(String amount,String format) {
    return (A)withDiskSize(new Quantity(amount, format));
  }
  
  public A withNewDiskSize(String amount) {
    return (A)withDiskSize(new Quantity(amount));
  }
  
  public StorageConfig buildStorageConfig() {
    return this.storageConfig != null ? this.storageConfig.build() : null;
  }
  
  public A withStorageConfig(StorageConfig storageConfig) {
    this._visitables.remove("storageConfig");
    if (storageConfig != null) {
        this.storageConfig = new StorageConfigBuilder(storageConfig);
        this._visitables.get("storageConfig").add(this.storageConfig);
    } else {
        this.storageConfig = null;
        this._visitables.get("storageConfig").remove(this.storageConfig);
    }
    return (A) this;
  }
  
  public boolean hasStorageConfig() {
    return this.storageConfig != null;
  }
  
  public StorageConfigNested<A> withNewStorageConfig() {
    return new StorageConfigNested(null);
  }
  
  public StorageConfigNested<A> withNewStorageConfigLike(StorageConfig item) {
    return new StorageConfigNested(item);
  }
  
  public StorageConfigNested<A> editStorageConfig() {
    return withNewStorageConfigLike(java.util.Optional.ofNullable(buildStorageConfig()).orElse(null));
  }
  
  public StorageConfigNested<A> editOrNewStorageConfig() {
    return withNewStorageConfigLike(java.util.Optional.ofNullable(buildStorageConfig()).orElse(new StorageConfigBuilder().build()));
  }
  
  public StorageConfigNested<A> editOrNewStorageConfigLike(StorageConfig item) {
    return withNewStorageConfigLike(java.util.Optional.ofNullable(buildStorageConfig()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DataDiskFluent that = (DataDiskFluent) o;
    if (!java.util.Objects.equals(dataSourceImage, that.dataSourceImage)) return false;
    if (!java.util.Objects.equals(deviceProperties, that.deviceProperties)) return false;
    if (!java.util.Objects.equals(diskSize, that.diskSize)) return false;
    if (!java.util.Objects.equals(storageConfig, that.storageConfig)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dataSourceImage,  deviceProperties,  diskSize,  storageConfig,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dataSourceImage != null) { sb.append("dataSourceImage:"); sb.append(dataSourceImage + ","); }
    if (deviceProperties != null) { sb.append("deviceProperties:"); sb.append(deviceProperties + ","); }
    if (diskSize != null) { sb.append("diskSize:"); sb.append(diskSize + ","); }
    if (storageConfig != null) { sb.append("storageConfig:"); sb.append(storageConfig + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DataSourceImageNested<N> extends StorageResourceReferenceFluent<DataSourceImageNested<N>> implements Nested<N>{
    DataSourceImageNested(StorageResourceReference item) {
      this.builder = new StorageResourceReferenceBuilder(this, item);
    }
    StorageResourceReferenceBuilder builder;
    
    public N and() {
      return (N) DataDiskFluent.this.withDataSourceImage(builder.build());
    }
    
    public N endDataSourceImage() {
      return and();
    }
    
  
  }
  public class StorageConfigNested<N> extends StorageConfigFluent<StorageConfigNested<N>> implements Nested<N>{
    StorageConfigNested(StorageConfig item) {
      this.builder = new StorageConfigBuilder(this, item);
    }
    StorageConfigBuilder builder;
    
    public N and() {
      return (N) DataDiskFluent.this.withStorageConfig(builder.build());
    }
    
    public N endStorageConfig() {
      return and();
    }
    
  
  }

}