package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachinePoolBuilder extends MachinePoolFluent<MachinePoolBuilder> implements VisitableBuilder<MachinePool,MachinePoolBuilder>{
  public MachinePoolBuilder() {
    this(new MachinePool());
  }
  
  public MachinePoolBuilder(MachinePoolFluent<?> fluent) {
    this(fluent, new MachinePool());
  }
  
  public MachinePoolBuilder(MachinePoolFluent<?> fluent,MachinePool instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachinePoolBuilder(MachinePool instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachinePoolFluent<?> fluent;
  
  public MachinePool build() {
    MachinePool buildable = new MachinePool(fluent.getBootType(),fluent.getCategories(),fluent.getCoresPerSocket(),fluent.getCpus(),fluent.buildDataDisks(),fluent.getFailureDomains(),fluent.getGpus(),fluent.getMemoryMiB(),fluent.buildOsDisk(),fluent.getProject());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}