package io.fabric8.openshift.api.model.installer.nutanix.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetadataFluent<A extends MetadataFluent<A>> extends BaseFluent<A>{
  public MetadataFluent() {
  }
  
  public MetadataFluent(Metadata instance) {
    this.copyInstance(instance);
  }
  private String password;
  private String port;
  private String prismCentral;
  private String username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Metadata instance) {
    instance = (instance != null ? instance : new Metadata());
    if (instance != null) {
          this.withPassword(instance.getPassword());
          this.withPort(instance.getPort());
          this.withPrismCentral(instance.getPrismCentral());
          this.withUsername(instance.getUsername());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getPassword() {
    return this.password;
  }
  
  public A withPassword(String password) {
    this.password = password;
    return (A) this;
  }
  
  public boolean hasPassword() {
    return this.password != null;
  }
  
  public String getPort() {
    return this.port;
  }
  
  public A withPort(String port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getPrismCentral() {
    return this.prismCentral;
  }
  
  public A withPrismCentral(String prismCentral) {
    this.prismCentral = prismCentral;
    return (A) this;
  }
  
  public boolean hasPrismCentral() {
    return this.prismCentral != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetadataFluent that = (MetadataFluent) o;
    if (!java.util.Objects.equals(password, that.password)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(prismCentral, that.prismCentral)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(password,  port,  prismCentral,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (password != null) { sb.append("password:"); sb.append(password + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (prismCentral != null) { sb.append("prismCentral:"); sb.append(prismCentral + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}