package io.fabric8.openshift.api.model.installer.powervs.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RegionFluent<A extends RegionFluent<A>> extends BaseFluent<A>{
  public RegionFluent() {
  }
  
  public RegionFluent(Region instance) {
    this.copyInstance(instance);
  }
  private String cOSRegion;
  private String description;
  private List<String> sysTypes = new ArrayList<String>();
  private String vPCRegion;
  private List<String> vPCZones = new ArrayList<String>();
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Region instance) {
    instance = (instance != null ? instance : new Region());
    if (instance != null) {
          this.withCOSRegion(instance.getCOSRegion());
          this.withDescription(instance.getDescription());
          this.withSysTypes(instance.getSysTypes());
          this.withVPCRegion(instance.getVPCRegion());
          this.withVPCZones(instance.getVPCZones());
          this.withZones(instance.getZones());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCOSRegion() {
    return this.cOSRegion;
  }
  
  public A withCOSRegion(String cOSRegion) {
    this.cOSRegion = cOSRegion;
    return (A) this;
  }
  
  public boolean hasCOSRegion() {
    return this.cOSRegion != null;
  }
  
  public String getDescription() {
    return this.description;
  }
  
  public A withDescription(String description) {
    this.description = description;
    return (A) this;
  }
  
  public boolean hasDescription() {
    return this.description != null;
  }
  
  public A addToSysTypes(int index,String item) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    this.sysTypes.add(index, item);
    return (A)this;
  }
  
  public A setToSysTypes(int index,String item) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    this.sysTypes.set(index, item); return (A)this;
  }
  
  public A addToSysTypes(java.lang.String... items) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    for (String item : items) {this.sysTypes.add(item);} return (A)this;
  }
  
  public A addAllToSysTypes(Collection<String> items) {
    if (this.sysTypes == null) {this.sysTypes = new ArrayList<String>();}
    for (String item : items) {this.sysTypes.add(item);} return (A)this;
  }
  
  public A removeFromSysTypes(java.lang.String... items) {
    if (this.sysTypes == null) return (A)this;
    for (String item : items) { this.sysTypes.remove(item);} return (A)this;
  }
  
  public A removeAllFromSysTypes(Collection<String> items) {
    if (this.sysTypes == null) return (A)this;
    for (String item : items) { this.sysTypes.remove(item);} return (A)this;
  }
  
  public List<String> getSysTypes() {
    return this.sysTypes;
  }
  
  public String getSysType(int index) {
    return this.sysTypes.get(index);
  }
  
  public String getFirstSysType() {
    return this.sysTypes.get(0);
  }
  
  public String getLastSysType() {
    return this.sysTypes.get(sysTypes.size() - 1);
  }
  
  public String getMatchingSysType(Predicate<String> predicate) {
      for (String item : sysTypes) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSysType(Predicate<String> predicate) {
      for (String item : sysTypes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSysTypes(List<String> sysTypes) {
    if (sysTypes != null) {
        this.sysTypes = new ArrayList();
        for (String item : sysTypes) {
          this.addToSysTypes(item);
        }
    } else {
      this.sysTypes = null;
    }
    return (A) this;
  }
  
  public A withSysTypes(java.lang.String... sysTypes) {
    if (this.sysTypes != null) {
        this.sysTypes.clear();
        _visitables.remove("sysTypes");
    }
    if (sysTypes != null) {
      for (String item : sysTypes) {
        this.addToSysTypes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSysTypes() {
    return this.sysTypes != null && !this.sysTypes.isEmpty();
  }
  
  public String getVPCRegion() {
    return this.vPCRegion;
  }
  
  public A withVPCRegion(String vPCRegion) {
    this.vPCRegion = vPCRegion;
    return (A) this;
  }
  
  public boolean hasVPCRegion() {
    return this.vPCRegion != null;
  }
  
  public A addToVPCZones(int index,String item) {
    if (this.vPCZones == null) {this.vPCZones = new ArrayList<String>();}
    this.vPCZones.add(index, item);
    return (A)this;
  }
  
  public A setToVPCZones(int index,String item) {
    if (this.vPCZones == null) {this.vPCZones = new ArrayList<String>();}
    this.vPCZones.set(index, item); return (A)this;
  }
  
  public A addToVPCZones(java.lang.String... items) {
    if (this.vPCZones == null) {this.vPCZones = new ArrayList<String>();}
    for (String item : items) {this.vPCZones.add(item);} return (A)this;
  }
  
  public A addAllToVPCZones(Collection<String> items) {
    if (this.vPCZones == null) {this.vPCZones = new ArrayList<String>();}
    for (String item : items) {this.vPCZones.add(item);} return (A)this;
  }
  
  public A removeFromVPCZones(java.lang.String... items) {
    if (this.vPCZones == null) return (A)this;
    for (String item : items) { this.vPCZones.remove(item);} return (A)this;
  }
  
  public A removeAllFromVPCZones(Collection<String> items) {
    if (this.vPCZones == null) return (A)this;
    for (String item : items) { this.vPCZones.remove(item);} return (A)this;
  }
  
  public List<String> getVPCZones() {
    return this.vPCZones;
  }
  
  public String getVPCZone(int index) {
    return this.vPCZones.get(index);
  }
  
  public String getFirstVPCZone() {
    return this.vPCZones.get(0);
  }
  
  public String getLastVPCZone() {
    return this.vPCZones.get(vPCZones.size() - 1);
  }
  
  public String getMatchingVPCZone(Predicate<String> predicate) {
      for (String item : vPCZones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingVPCZone(Predicate<String> predicate) {
      for (String item : vPCZones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVPCZones(List<String> vPCZones) {
    if (vPCZones != null) {
        this.vPCZones = new ArrayList();
        for (String item : vPCZones) {
          this.addToVPCZones(item);
        }
    } else {
      this.vPCZones = null;
    }
    return (A) this;
  }
  
  public A withVPCZones(java.lang.String... vPCZones) {
    if (this.vPCZones != null) {
        this.vPCZones.clear();
        _visitables.remove("vPCZones");
    }
    if (vPCZones != null) {
      for (String item : vPCZones) {
        this.addToVPCZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVPCZones() {
    return this.vPCZones != null && !this.vPCZones.isEmpty();
  }
  
  public A addToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  
  public A setToZones(int index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  
  public A removeFromZones(java.lang.String... items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public A removeAllFromZones(Collection<String> items) {
    if (this.zones == null) return (A)this;
    for (String item : items) { this.zones.remove(item);} return (A)this;
  }
  
  public List<String> getZones() {
    return this.zones;
  }
  
  public String getZone(int index) {
    return this.zones.get(index);
  }
  
  public String getFirstZone() {
    return this.zones.get(0);
  }
  
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  
  public String getMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingZone(Predicate<String> predicate) {
      for (String item : zones) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withZones(List<String> zones) {
    if (zones != null) {
        this.zones = new ArrayList();
        for (String item : zones) {
          this.addToZones(item);
        }
    } else {
      this.zones = null;
    }
    return (A) this;
  }
  
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {
        this.zones.clear();
        _visitables.remove("zones");
    }
    if (zones != null) {
      for (String item : zones) {
        this.addToZones(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasZones() {
    return this.zones != null && !this.zones.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RegionFluent that = (RegionFluent) o;
    if (!java.util.Objects.equals(cOSRegion, that.cOSRegion)) return false;
    if (!java.util.Objects.equals(description, that.description)) return false;
    if (!java.util.Objects.equals(sysTypes, that.sysTypes)) return false;
    if (!java.util.Objects.equals(vPCRegion, that.vPCRegion)) return false;
    if (!java.util.Objects.equals(vPCZones, that.vPCZones)) return false;
    if (!java.util.Objects.equals(zones, that.zones)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cOSRegion,  description,  sysTypes,  vPCRegion,  vPCZones,  zones,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cOSRegion != null) { sb.append("cOSRegion:"); sb.append(cOSRegion + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (sysTypes != null && !sysTypes.isEmpty()) { sb.append("sysTypes:"); sb.append(sysTypes + ","); }
    if (vPCRegion != null) { sb.append("vPCRegion:"); sb.append(vPCRegion + ","); }
    if (vPCZones != null && !vPCZones.isEmpty()) { sb.append("vPCZones:"); sb.append(vPCZones + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}