package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterPlatformMetadataBuilder extends ClusterPlatformMetadataFluent<ClusterPlatformMetadataBuilder> implements VisitableBuilder<ClusterPlatformMetadata,ClusterPlatformMetadataBuilder>{
  public ClusterPlatformMetadataBuilder() {
    this(new ClusterPlatformMetadata());
  }
  
  public ClusterPlatformMetadataBuilder(ClusterPlatformMetadataFluent<?> fluent) {
    this(fluent, new ClusterPlatformMetadata());
  }
  
  public ClusterPlatformMetadataBuilder(ClusterPlatformMetadataFluent<?> fluent,ClusterPlatformMetadata instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterPlatformMetadataBuilder(ClusterPlatformMetadata instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterPlatformMetadataFluent<?> fluent;
  
  public ClusterPlatformMetadata build() {
    ClusterPlatformMetadata buildable = new ClusterPlatformMetadata(fluent.buildAws(),fluent.buildAzure(),fluent.buildBaremetal(),fluent.buildGcp(),fluent.buildIbmcloud(),fluent.buildNutanix(),fluent.buildOpenstack(),fluent.buildOvirt(),fluent.buildPowervs(),fluent.buildVsphere());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}