/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.DataDisk;
import io.fabric8.openshift.api.model.installer.vsphere.v1.DataDiskBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.DataDiskFluent;
import io.fabric8.openshift.api.model.installer.vsphere.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.vsphere.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.OSDiskFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private Integer coresPerSocket;
    private Integer cpus;
    private ArrayList<DataDiskBuilder> dataDisks = new ArrayList();
    private Long memoryMB;
    private OSDiskBuilder osDisk;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withCoresPerSocket(instance.getCoresPerSocket());
            this.withCpus(instance.getCpus());
            this.withDataDisks(instance.getDataDisks());
            this.withMemoryMB(instance.getMemoryMB());
            this.withOsDisk(instance.getOsDisk());
            this.withZones(instance.getZones());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public A withCoresPerSocket(Integer coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
        return (A)((Object)this);
    }

    public boolean hasCoresPerSocket() {
        return this.coresPerSocket != null;
    }

    public Integer getCpus() {
        return this.cpus;
    }

    public A withCpus(Integer cpus) {
        this.cpus = cpus;
        return (A)((Object)this);
    }

    public boolean hasCpus() {
        return this.cpus != null;
    }

    public A addToDataDisks(int index, DataDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        DataDiskBuilder builder = new DataDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDataDisks(int index, DataDisk item) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        DataDiskBuilder builder = new DataDiskBuilder(item);
        if (index < 0 || index >= this.dataDisks.size()) {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        } else {
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDataDisks(DataDisk ... items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDataDisks(Collection<DataDisk> items) {
        if (this.dataDisks == null) {
            this.dataDisks = new ArrayList();
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").add(builder);
            this.dataDisks.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDataDisks(DataDisk ... items) {
        if (this.dataDisks == null) {
            return (A)((Object)this);
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").remove((Object)builder);
            this.dataDisks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDataDisks(Collection<DataDisk> items) {
        if (this.dataDisks == null) {
            return (A)((Object)this);
        }
        for (DataDisk item : items) {
            DataDiskBuilder builder = new DataDiskBuilder(item);
            this._visitables.get((Object)"dataDisks").remove((Object)builder);
            this.dataDisks.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDataDisks(Predicate<DataDiskBuilder> predicate) {
        if (this.dataDisks == null) {
            return (A)((Object)this);
        }
        Iterator<DataDiskBuilder> each = this.dataDisks.iterator();
        List visitables = this._visitables.get((Object)"dataDisks");
        while (each.hasNext()) {
            DataDiskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DataDisk> buildDataDisks() {
        return this.dataDisks != null ? MachinePoolFluent.build(this.dataDisks) : null;
    }

    public DataDisk buildDataDisk(int index) {
        return this.dataDisks.get(index).build();
    }

    public DataDisk buildFirstDataDisk() {
        return this.dataDisks.get(0).build();
    }

    public DataDisk buildLastDataDisk() {
        return this.dataDisks.get(this.dataDisks.size() - 1).build();
    }

    public DataDisk buildMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        for (DataDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        for (DataDiskBuilder item : this.dataDisks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDataDisks(List<DataDisk> dataDisks) {
        if (this.dataDisks != null) {
            this._visitables.get((Object)"dataDisks").clear();
        }
        if (dataDisks != null) {
            this.dataDisks = new ArrayList();
            for (DataDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        } else {
            this.dataDisks = null;
        }
        return (A)((Object)this);
    }

    public A withDataDisks(DataDisk ... dataDisks) {
        if (this.dataDisks != null) {
            this.dataDisks.clear();
            this._visitables.remove((Object)"dataDisks");
        }
        if (dataDisks != null) {
            for (DataDisk item : dataDisks) {
                this.addToDataDisks(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDataDisks() {
        return this.dataDisks != null && !this.dataDisks.isEmpty();
    }

    public A addNewDataDisk(String name, String provisioningMode, Integer sizeGiB) {
        return this.addToDataDisks(new DataDisk(name, provisioningMode, sizeGiB));
    }

    public DataDisksNested<A> addNewDataDisk() {
        return new DataDisksNested(-1, null);
    }

    public DataDisksNested<A> addNewDataDiskLike(DataDisk item) {
        return new DataDisksNested(-1, item);
    }

    public DataDisksNested<A> setNewDataDiskLike(int index, DataDisk item) {
        return new DataDisksNested(index, item);
    }

    public DataDisksNested<A> editDataDisk(int index) {
        if (this.dataDisks.size() <= index) {
            throw new RuntimeException("Can't edit dataDisks. Index exceeds size.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editFirstDataDisk() {
        if (this.dataDisks.size() == 0) {
            throw new RuntimeException("Can't edit first dataDisks. The list is empty.");
        }
        return this.setNewDataDiskLike(0, this.buildDataDisk(0));
    }

    public DataDisksNested<A> editLastDataDisk() {
        int index = this.dataDisks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dataDisks. The list is empty.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDisksNested<A> editMatchingDataDisk(Predicate<DataDiskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dataDisks.size(); ++i) {
            if (!predicate.test(this.dataDisks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dataDisks. No match found.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public Long getMemoryMB() {
        return this.memoryMB;
    }

    public A withMemoryMB(Long memoryMB) {
        this.memoryMB = memoryMB;
        return (A)((Object)this);
    }

    public boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove((Object)"osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get((Object)"osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get((Object)"osDisk").remove((Object)this.osDisk);
        }
        return (A)((Object)this);
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public A withNewOsDisk(Integer diskSizeGB) {
        return this.withOsDisk(new OSDisk(diskSizeGB));
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public A addToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)((Object)this);
    }

    public A setToZones(int index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)((Object)this);
    }

    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromZones(String ... items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromZones(Collection<String> items) {
        if (this.zones == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.zones.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getZones() {
        return this.zones;
    }

    public String getZone(int index) {
        return this.zones.get(index);
    }

    public String getFirstZone() {
        return this.zones.get(0);
    }

    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)((Object)this);
    }

    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
            this._visitables.remove((Object)"zones");
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)((Object)o);
        if (!Objects.equals(this.coresPerSocket, that.coresPerSocket)) {
            return false;
        }
        if (!Objects.equals(this.cpus, that.cpus)) {
            return false;
        }
        if (!Objects.equals(this.dataDisks, that.dataDisks)) {
            return false;
        }
        if (!Objects.equals(this.memoryMB, that.memoryMB)) {
            return false;
        }
        if (!Objects.equals((Object)this.osDisk, (Object)that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.zones, that.zones)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.coresPerSocket, this.cpus, this.dataDisks, this.memoryMB, this.osDisk, this.zones, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.coresPerSocket != null) {
            sb.append("coresPerSocket:");
            sb.append(this.coresPerSocket + ",");
        }
        if (this.cpus != null) {
            sb.append("cpus:");
            sb.append(this.cpus + ",");
        }
        if (this.dataDisks != null && !this.dataDisks.isEmpty()) {
            sb.append("dataDisks:");
            sb.append(String.valueOf(this.dataDisks) + ",");
        }
        if (this.memoryMB != null) {
            sb.append("memoryMB:");
            sb.append(this.memoryMB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(String.valueOf((Object)this.osDisk) + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(String.valueOf(this.zones) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }

    public class DataDisksNested<N>
    extends DataDiskFluent<DataDisksNested<N>>
    implements Nested<N> {
        DataDiskBuilder builder;
        int index;

        DataDisksNested(int index, DataDisk item) {
            this.index = index;
            this.builder = new DataDiskBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.setToDataDisks(this.index, this.builder.build());
        }

        public N endDataDisk() {
            return this.and();
        }
    }
}

