package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.NodeAddress;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class MachineStatusFluentImpl<A extends io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<A>{
  public MachineStatusFluentImpl() {
  }
  public MachineStatusFluentImpl(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withConditions(instance.getConditions()); 
    this.withErrorMessage(instance.getErrorMessage()); 
    this.withErrorReason(instance.getErrorReason()); 
    this.withLastOperation(instance.getLastOperation()); 
    this.withLastUpdated(instance.getLastUpdated()); 
    this.withNodeRef(instance.getNodeRef()); 
    this.withPhase(instance.getPhase()); 
    this.withProviderStatus(instance.getProviderStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.util.List<io.fabric8.kubernetes.api.model.NodeAddress> addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddress>();
  private java.util.List<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder>();
  private java.lang.String errorMessage;
  private java.lang.String errorReason;
  private io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder lastOperation;
  private java.lang.String lastUpdated;
  private io.fabric8.kubernetes.api.model.ObjectReferenceBuilder nodeRef;
  private java.lang.String phase;
  private java.util.Map<java.lang.String,java.lang.Object> providerStatus;
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public A addToAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeAddress item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddress>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  public A setToAddresses(java.lang.Integer index,io.fabric8.kubernetes.api.model.NodeAddress item) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddress>();}
    this.addresses.set(index, item); return (A)this;
  }
  public A addToAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddress>();}
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {this.addresses.add(item);} return (A)this;
  }
  public A addAllToAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.NodeAddress> items) {
    if (this.addresses == null) {this.addresses = new java.util.ArrayList<io.fabric8.kubernetes.api.model.NodeAddress>();}
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {this.addresses.add(item);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.NodeAddress... items) {
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public A removeAllFromAddresses(java.util.Collection<io.fabric8.kubernetes.api.model.NodeAddress> items) {
    for (io.fabric8.kubernetes.api.model.NodeAddress item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.NodeAddress> getAddresses() {
    return this.addresses;
  }
  public io.fabric8.kubernetes.api.model.NodeAddress getAddress(java.lang.Integer index) {
    return this.addresses.get(index);
  }
  public io.fabric8.kubernetes.api.model.NodeAddress getFirstAddress() {
    return this.addresses.get(0);
  }
  public io.fabric8.kubernetes.api.model.NodeAddress getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.NodeAddress getMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeAddress> predicate) {
    for (io.fabric8.kubernetes.api.model.NodeAddress item: addresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAddress(java.util.function.Predicate<io.fabric8.kubernetes.api.model.NodeAddress> predicate) {
    for (io.fabric8.kubernetes.api.model.NodeAddress item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(java.util.List<io.fabric8.kubernetes.api.model.NodeAddress> addresses) {
    if (addresses != null) {this.addresses = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.NodeAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.kubernetes.api.model.NodeAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (io.fabric8.kubernetes.api.model.NodeAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public java.lang.Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(java.lang.String address,java.lang.String type) {
    return (A)addToAddresses(new NodeAddress(address, type));
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.machine.v1beta1.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder>();}
    io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.openshift.api.model.machine.v1beta1.Condition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder>();}
    io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder>();}
    for (io.fabric8.openshift.api.model.machine.v1beta1.Condition item : items) {io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.openshift.api.model.machine.v1beta1.Condition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder>();}
    for (io.fabric8.openshift.api.model.machine.v1beta1.Condition item : items) {io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... items) {
    for (io.fabric8.openshift.api.model.machine.v1beta1.Condition item : items) {io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.openshift.api.model.machine.v1beta1.Condition> items) {
    for (io.fabric8.openshift.api.model.machine.v1beta1.Condition item : items) {io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.machine.v1beta1.Condition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.openshift.api.model.machine.v1beta1.Condition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.Condition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.Condition buildMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder> predicate) {
    for (io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.openshift.api.model.machine.v1beta1.Condition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.machine.v1beta1.Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.machine.v1beta1.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.openshift.api.model.machine.v1beta1.Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.openshift.api.model.machine.v1beta1.Condition item) {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.openshift.api.model.machine.v1beta1.Condition item) {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.String getErrorMessage() {
    return this.errorMessage;
  }
  public A withErrorMessage(java.lang.String errorMessage) {
    this.errorMessage=errorMessage; return (A) this;
  }
  public java.lang.Boolean hasErrorMessage() {
    return this.errorMessage != null;
  }
  
  /**
   * Method is deprecated. use withErrorMessage instead.
   */
  @java.lang.Deprecated
  public A withNewErrorMessage(java.lang.String arg0) {
    return (A)withErrorMessage(new String(arg0));
  }
  public java.lang.String getErrorReason() {
    return this.errorReason;
  }
  public A withErrorReason(java.lang.String errorReason) {
    this.errorReason=errorReason; return (A) this;
  }
  public java.lang.Boolean hasErrorReason() {
    return this.errorReason != null;
  }
  
  /**
   * Method is deprecated. use withErrorReason instead.
   */
  @java.lang.Deprecated
  public A withNewErrorReason(java.lang.String arg0) {
    return (A)withErrorReason(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildLastOperation instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.machine.v1beta1.LastOperation getLastOperation() {
    return this.lastOperation!=null?this.lastOperation.build():null;
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.LastOperation buildLastOperation() {
    return this.lastOperation!=null?this.lastOperation.build():null;
  }
  public A withLastOperation(io.fabric8.openshift.api.model.machine.v1beta1.LastOperation lastOperation) {
    _visitables.get("lastOperation").remove(this.lastOperation);
    if (lastOperation!=null){ this.lastOperation= new io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder(lastOperation); _visitables.get("lastOperation").add(this.lastOperation);} return (A) this;
  }
  public java.lang.Boolean hasLastOperation() {
    return this.lastOperation != null;
  }
  public A withNewLastOperation(java.lang.String description,java.lang.String lastUpdated,java.lang.String state,java.lang.String type) {
    return (A)withLastOperation(new LastOperation(description, lastUpdated, state, type));
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<A> withNewLastOperation() {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.LastOperationNestedImpl();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<A> withNewLastOperationLike(io.fabric8.openshift.api.model.machine.v1beta1.LastOperation item) {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.LastOperationNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<A> editLastOperation() {
    return withNewLastOperationLike(getLastOperation());
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<A> editOrNewLastOperation() {
    return withNewLastOperationLike(getLastOperation() != null ? getLastOperation(): new io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder().build());
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<A> editOrNewLastOperationLike(io.fabric8.openshift.api.model.machine.v1beta1.LastOperation item) {
    return withNewLastOperationLike(getLastOperation() != null ? getLastOperation(): item);
  }
  public java.lang.String getLastUpdated() {
    return this.lastUpdated;
  }
  public A withLastUpdated(java.lang.String lastUpdated) {
    this.lastUpdated=lastUpdated; return (A) this;
  }
  public java.lang.Boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  
  /**
   * Method is deprecated. use withLastUpdated instead.
   */
  @java.lang.Deprecated
  public A withNewLastUpdated(java.lang.String arg0) {
    return (A)withLastUpdated(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildNodeRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getNodeRef() {
    return this.nodeRef!=null?this.nodeRef.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildNodeRef() {
    return this.nodeRef!=null?this.nodeRef.build():null;
  }
  public A withNodeRef(io.fabric8.kubernetes.api.model.ObjectReference nodeRef) {
    _visitables.get("nodeRef").remove(this.nodeRef);
    if (nodeRef!=null){ this.nodeRef= new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(nodeRef); _visitables.get("nodeRef").add(this.nodeRef);} return (A) this;
  }
  public java.lang.Boolean hasNodeRef() {
    return this.nodeRef != null;
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<A> withNewNodeRef() {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.NodeRefNestedImpl();
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<A> withNewNodeRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl.NodeRefNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<A> editNodeRef() {
    return withNewNodeRefLike(getNodeRef());
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<A> editOrNewNodeRef() {
    return withNewNodeRefLike(getNodeRef() != null ? getNodeRef(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<A> editOrNewNodeRefLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewNodeRefLike(getNodeRef() != null ? getNodeRef(): item);
  }
  public java.lang.String getPhase() {
    return this.phase;
  }
  public A withPhase(java.lang.String phase) {
    this.phase=phase; return (A) this;
  }
  public java.lang.Boolean hasPhase() {
    return this.phase != null;
  }
  
  /**
   * Method is deprecated. use withPhase instead.
   */
  @java.lang.Deprecated
  public A withNewPhase(java.lang.String arg0) {
    return (A)withPhase(new String(arg0));
  }
  public A addToProviderStatus(java.lang.String key,java.lang.Object value) {
    if(this.providerStatus == null && key != null && value != null) { this.providerStatus = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.providerStatus.put(key, value);} return (A)this;
  }
  public A addToProviderStatus(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.providerStatus == null && map != null) { this.providerStatus = new java.util.LinkedHashMap(); }
    if(map != null) { this.providerStatus.putAll(map);} return (A)this;
  }
  public A removeFromProviderStatus(java.lang.String key) {
    if(this.providerStatus == null) { return (A) this; }
    if(key != null && this.providerStatus != null) {this.providerStatus.remove(key);} return (A)this;
  }
  public A removeFromProviderStatus(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.providerStatus == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.providerStatus != null){this.providerStatus.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getProviderStatus() {
    return this.providerStatus;
  }
  public <K,V>A withProviderStatus(java.util.Map<java.lang.String,java.lang.Object> providerStatus) {
    if (providerStatus == null) { this.providerStatus =  null;} else {this.providerStatus = new java.util.LinkedHashMap(providerStatus);} return (A) this;
  }
  public java.lang.Boolean hasProviderStatus() {
    return this.providerStatus != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachineStatusFluentImpl that = (MachineStatusFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (errorMessage != null ? !errorMessage.equals(that.errorMessage) :that.errorMessage != null) return false;
    if (errorReason != null ? !errorReason.equals(that.errorReason) :that.errorReason != null) return false;
    if (lastOperation != null ? !lastOperation.equals(that.lastOperation) :that.lastOperation != null) return false;
    if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
    if (nodeRef != null ? !nodeRef.equals(that.nodeRef) :that.nodeRef != null) return false;
    if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
    if (providerStatus != null ? !providerStatus.equals(that.providerStatus) :that.providerStatus != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  conditions,  errorMessage,  errorReason,  lastOperation,  lastUpdated,  nodeRef,  phase,  providerStatus,  additionalProperties,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.openshift.api.model.machine.v1beta1.ConditionFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<N>> implements io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.openshift.api.model.machine.v1beta1.Condition item) {
      this.index = index;
      this.builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder(this);
    }
    io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) MachineStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class LastOperationNestedImpl<N> extends io.fabric8.openshift.api.model.machine.v1beta1.LastOperationFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<N>> implements io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.LastOperationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    LastOperationNestedImpl(io.fabric8.openshift.api.model.machine.v1beta1.LastOperation item) {
      this.builder = new io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder(this, item);
    }
    LastOperationNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder(this);
    }
    io.fabric8.openshift.api.model.machine.v1beta1.LastOperationBuilder builder;
    public N and() {
      return (N) MachineStatusFluentImpl.this.withLastOperation(builder.build());
    }
    public N endLastOperation() {
      return and();
    }
    
  }
  public class NodeRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<N>> implements io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent.NodeRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NodeRefNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    NodeRefNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) MachineStatusFluentImpl.this.withNodeRef(builder.build());
    }
    public N endNodeRef() {
      return and();
    }
    
  }
  
}