package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MachineHealthCheckSpecBuilder extends io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec,io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecBuilder> {

    io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MachineHealthCheckSpecBuilder() {
        this(true);
    }

    public MachineHealthCheckSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new MachineHealthCheckSpec(), validationEnabled);
    }

    public MachineHealthCheckSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public MachineHealthCheckSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MachineHealthCheckSpec(), validationEnabled);
    }

    public MachineHealthCheckSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec instance) {
        this(fluent, instance, true);
    }

    public MachineHealthCheckSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpecFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMaxUnhealthy(instance.getMaxUnhealthy()); 
        fluent.withNodeStartupTimeout(instance.getNodeStartupTimeout()); 
        fluent.withRemediationTemplate(instance.getRemediationTemplate()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withUnhealthyConditions(instance.getUnhealthyConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public MachineHealthCheckSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec instance) {
        this(instance,true);
    }

    public MachineHealthCheckSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMaxUnhealthy(instance.getMaxUnhealthy()); 
        this.withNodeStartupTimeout(instance.getNodeStartupTimeout()); 
        this.withRemediationTemplate(instance.getRemediationTemplate()); 
        this.withSelector(instance.getSelector()); 
        this.withUnhealthyConditions(instance.getUnhealthyConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckSpec build() {
        MachineHealthCheckSpec buildable = new MachineHealthCheckSpec(fluent.getMaxUnhealthy(),fluent.getNodeStartupTimeout(),fluent.getRemediationTemplate(),fluent.getSelector(),fluent.getUnhealthyConditions());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MachineHealthCheckSpecBuilder that = (MachineHealthCheckSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
