package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MachineHealthCheckStatusBuilder extends io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus,io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusBuilder> {

    io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MachineHealthCheckStatusBuilder() {
        this(true);
    }

    public MachineHealthCheckStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new MachineHealthCheckStatus(), validationEnabled);
    }

    public MachineHealthCheckStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public MachineHealthCheckStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MachineHealthCheckStatus(), validationEnabled);
    }

    public MachineHealthCheckStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus instance) {
        this(fluent, instance, true);
    }

    public MachineHealthCheckStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConditions(instance.getConditions()); 
        fluent.withCurrentHealthy(instance.getCurrentHealthy()); 
        fluent.withExpectedMachines(instance.getExpectedMachines()); 
        fluent.withRemediationsAllowed(instance.getRemediationsAllowed()); 
        this.validationEnabled = validationEnabled; 
    }

    public MachineHealthCheckStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus instance) {
        this(instance,true);
    }

    public MachineHealthCheckStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withConditions(instance.getConditions()); 
        this.withCurrentHealthy(instance.getCurrentHealthy()); 
        this.withExpectedMachines(instance.getExpectedMachines()); 
        this.withRemediationsAllowed(instance.getRemediationsAllowed()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus build() {
        MachineHealthCheckStatus buildable = new MachineHealthCheckStatus(fluent.getConditions(),fluent.getCurrentHealthy(),fluent.getExpectedMachines(),fluent.getRemediationsAllowed());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MachineHealthCheckStatusBuilder that = (MachineHealthCheckStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
