package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MachineSetBuilder extends io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineSetBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machine.v1beta1.MachineSet,io.fabric8.openshift.api.model.machine.v1beta1.MachineSetBuilder> {

    io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MachineSetBuilder() {
        this(true);
    }

    public MachineSetBuilder(java.lang.Boolean validationEnabled) {
        this(new MachineSet(), validationEnabled);
    }

    public MachineSetBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluent<?> fluent) {
        this(fluent, true);
    }

    public MachineSetBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MachineSet(), validationEnabled);
    }

    public MachineSetBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineSet instance) {
        this(fluent, instance, true);
    }

    public MachineSetBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineSet instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public MachineSetBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSet instance) {
        this(instance,true);
    }

    public MachineSetBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSet instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machine.v1beta1.MachineSet build() {
        MachineSet buildable = new MachineSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MachineSetBuilder that = (MachineSetBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
