package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MachineSetStatusBuilder extends io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus,io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusBuilder> {

    io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MachineSetStatusBuilder() {
        this(true);
    }

    public MachineSetStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new MachineSetStatus(), validationEnabled);
    }

    public MachineSetStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public MachineSetStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MachineSetStatus(), validationEnabled);
    }

    public MachineSetStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus instance) {
        this(fluent, instance, true);
    }

    public MachineSetStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatusFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
        fluent.withErrorMessage(instance.getErrorMessage()); 
        fluent.withErrorReason(instance.getErrorReason()); 
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public MachineSetStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus instance) {
        this(instance,true);
    }

    public MachineSetStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAvailableReplicas(instance.getAvailableReplicas()); 
        this.withErrorMessage(instance.getErrorMessage()); 
        this.withErrorReason(instance.getErrorReason()); 
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus build() {
        MachineSetStatus buildable = new MachineSetStatus(fluent.getAvailableReplicas(),fluent.getErrorMessage(),fluent.getErrorReason(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MachineSetStatusBuilder that = (MachineSetStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
