package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MachineSpecBuilder extends io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec,io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecBuilder> {

    io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MachineSpecBuilder() {
        this(true);
    }

    public MachineSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new MachineSpec(), validationEnabled);
    }

    public MachineSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public MachineSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MachineSpec(), validationEnabled);
    }

    public MachineSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec instance) {
        this(fluent, instance, true);
    }

    public MachineSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSpecFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withProviderID(instance.getProviderID()); 
        fluent.withProviderSpec(instance.getProviderSpec()); 
        fluent.withTaints(instance.getTaints()); 
        this.validationEnabled = validationEnabled; 
    }

    public MachineSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec instance) {
        this(instance,true);
    }

    public MachineSpecBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata()); 
        this.withProviderID(instance.getProviderID()); 
        this.withProviderSpec(instance.getProviderSpec()); 
        this.withTaints(instance.getTaints()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machine.v1beta1.MachineSpec build() {
        MachineSpec buildable = new MachineSpec(fluent.getMetadata(),fluent.getProviderID(),fluent.getProviderSpec(),fluent.getTaints());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MachineSpecBuilder that = (MachineSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
