package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MachineStatusBuilder extends io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluentImpl<io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus,io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusBuilder> {

    io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MachineStatusBuilder() {
        this(true);
    }

    public MachineStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new MachineStatus(), validationEnabled);
    }

    public MachineStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public MachineStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MachineStatus(), validationEnabled);
    }

    public MachineStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus instance) {
        this(fluent, instance, true);
    }

    public MachineStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatusFluent<?> fluent,io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAddresses(instance.getAddresses()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withErrorMessage(instance.getErrorMessage()); 
        fluent.withErrorReason(instance.getErrorReason()); 
        fluent.withLastOperation(instance.getLastOperation()); 
        fluent.withLastUpdated(instance.getLastUpdated()); 
        fluent.withNodeRef(instance.getNodeRef()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withProviderStatus(instance.getProviderStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public MachineStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus instance) {
        this(instance,true);
    }

    public MachineStatusBuilder(io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAddresses(instance.getAddresses()); 
        this.withConditions(instance.getConditions()); 
        this.withErrorMessage(instance.getErrorMessage()); 
        this.withErrorReason(instance.getErrorReason()); 
        this.withLastOperation(instance.getLastOperation()); 
        this.withLastUpdated(instance.getLastUpdated()); 
        this.withNodeRef(instance.getNodeRef()); 
        this.withPhase(instance.getPhase()); 
        this.withProviderStatus(instance.getProviderStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.machine.v1beta1.MachineStatus build() {
        MachineStatus buildable = new MachineStatus(fluent.getAddresses(),fluent.getConditions(),fluent.getErrorMessage(),fluent.getErrorReason(),fluent.getLastOperation(),fluent.getLastUpdated(),fluent.getNodeRef(),fluent.getPhase(),fluent.getProviderStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MachineStatusBuilder that = (MachineStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
