package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineListBuilder extends MachineListFluentImpl<MachineListBuilder> implements VisitableBuilder<MachineList,MachineListBuilder>{
  public MachineListBuilder() {
    this(false);
  }
  public MachineListBuilder(Boolean validationEnabled) {
    this(new MachineList(), validationEnabled);
  }
  public MachineListBuilder(MachineListFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineListBuilder(MachineListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineList(), validationEnabled);
  }
  public MachineListBuilder(MachineListFluent<?> fluent,MachineList instance) {
    this(fluent, instance, false);
  }
  public MachineListBuilder(MachineListFluent<?> fluent,MachineList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineListBuilder(MachineList instance) {
    this(instance,false);
  }
  public MachineListBuilder(MachineList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineListFluent<?> fluent;
  Boolean validationEnabled;
  public MachineList build() {
    MachineList buildable = new MachineList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}