package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineStatusBuilder extends MachineStatusFluentImpl<MachineStatusBuilder> implements VisitableBuilder<MachineStatus,MachineStatusBuilder>{
  public MachineStatusBuilder() {
    this(false);
  }
  public MachineStatusBuilder(Boolean validationEnabled) {
    this(new MachineStatus(), validationEnabled);
  }
  public MachineStatusBuilder(MachineStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineStatusBuilder(MachineStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineStatus(), validationEnabled);
  }
  public MachineStatusBuilder(MachineStatusFluent<?> fluent,MachineStatus instance) {
    this(fluent, instance, false);
  }
  public MachineStatusBuilder(MachineStatusFluent<?> fluent,MachineStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddresses(instance.getAddresses()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withErrorMessage(instance.getErrorMessage()); 
    fluent.withErrorReason(instance.getErrorReason()); 
    fluent.withLastOperation(instance.getLastOperation()); 
    fluent.withLastUpdated(instance.getLastUpdated()); 
    fluent.withNodeRef(instance.getNodeRef()); 
    fluent.withPhase(instance.getPhase()); 
    fluent.withProviderStatus(instance.getProviderStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachineStatusBuilder(MachineStatus instance) {
    this(instance,false);
  }
  public MachineStatusBuilder(MachineStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddresses(instance.getAddresses()); 
    this.withConditions(instance.getConditions()); 
    this.withErrorMessage(instance.getErrorMessage()); 
    this.withErrorReason(instance.getErrorReason()); 
    this.withLastOperation(instance.getLastOperation()); 
    this.withLastUpdated(instance.getLastUpdated()); 
    this.withNodeRef(instance.getNodeRef()); 
    this.withPhase(instance.getPhase()); 
    this.withProviderStatus(instance.getProviderStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachineStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachineStatus build() {
    MachineStatus buildable = new MachineStatus(fluent.getAddresses(),fluent.getConditions(),fluent.getErrorMessage(),fluent.getErrorReason(),fluent.getLastOperation(),fluent.getLastUpdated(),fluent.getNodeRef(),fluent.getPhase(),fluent.getProviderStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}