package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleHooksBuilder extends LifecycleHooksFluentImpl<LifecycleHooksBuilder> implements VisitableBuilder<LifecycleHooks,LifecycleHooksBuilder>{
  public LifecycleHooksBuilder() {
    this(false);
  }
  public LifecycleHooksBuilder(Boolean validationEnabled) {
    this(new LifecycleHooks(), validationEnabled);
  }
  public LifecycleHooksBuilder(LifecycleHooksFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleHooksBuilder(LifecycleHooksFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LifecycleHooks(), validationEnabled);
  }
  public LifecycleHooksBuilder(LifecycleHooksFluent<?> fluent,LifecycleHooks instance) {
    this(fluent, instance, false);
  }
  public LifecycleHooksBuilder(LifecycleHooksFluent<?> fluent,LifecycleHooks instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withPreDrain(instance.getPreDrain());
      fluent.withPreTerminate(instance.getPreTerminate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LifecycleHooksBuilder(LifecycleHooks instance) {
    this(instance,false);
  }
  public LifecycleHooksBuilder(LifecycleHooks instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withPreDrain(instance.getPreDrain());
      this.withPreTerminate(instance.getPreTerminate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LifecycleHooksFluent<?> fluent;
  Boolean validationEnabled;
  public LifecycleHooks build() {
    LifecycleHooks buildable = new LifecycleHooks(fluent.getPreDrain(),fluent.getPreTerminate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}