package io.fabric8.openshift.api.model.machine.v1beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface MachineSetSpecFluent<A extends MachineSetSpecFluent<A>> extends Fluent<A>{
  public String getDeletePolicy();
  public A withDeletePolicy(String deletePolicy);
  public Boolean hasDeletePolicy();
  public Integer getMinReadySeconds();
  public A withMinReadySeconds(Integer minReadySeconds);
  public Boolean hasMinReadySeconds();
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector();
  public LabelSelector buildSelector();
  public A withSelector(LabelSelector selector);
  public Boolean hasSelector();
  public MachineSetSpecFluent.SelectorNested<A> withNewSelector();
  public MachineSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
  public MachineSetSpecFluent.SelectorNested<A> editSelector();
  public MachineSetSpecFluent.SelectorNested<A> editOrNewSelector();
  public MachineSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachineTemplateSpec getTemplate();
  public MachineTemplateSpec buildTemplate();
  public A withTemplate(MachineTemplateSpec template);
  public Boolean hasTemplate();
  public MachineSetSpecFluent.TemplateNested<A> withNewTemplate();
  public MachineSetSpecFluent.TemplateNested<A> withNewTemplateLike(MachineTemplateSpec item);
  public MachineSetSpecFluent.TemplateNested<A> editTemplate();
  public MachineSetSpecFluent.TemplateNested<A> editOrNewTemplate();
  public MachineSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(MachineTemplateSpec item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<MachineSetSpecFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  public interface TemplateNested<N> extends Nested<N>,MachineTemplateSpecFluent<MachineSetSpecFluent.TemplateNested<N>>{
    public N and();
    public N endTemplate();
    
  }
  
}