package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetaBuilder extends ObjectMetaFluentImpl<ObjectMetaBuilder> implements VisitableBuilder<ObjectMeta,ObjectMetaBuilder>{
  public ObjectMetaBuilder() {
    this(false);
  }
  public ObjectMetaBuilder(Boolean validationEnabled) {
    this(new ObjectMeta(), validationEnabled);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectMeta(), validationEnabled);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance) {
    this(fluent, instance, false);
  }
  public ObjectMetaBuilder(ObjectMetaFluent<?> fluent,ObjectMeta instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withGenerateName(instance.getGenerateName());
      fluent.withLabels(instance.getLabels());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withOwnerReferences(instance.getOwnerReferences());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetaBuilder(ObjectMeta instance) {
    this(instance,false);
  }
  public ObjectMetaBuilder(ObjectMeta instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withGenerateName(instance.getGenerateName());
      this.withLabels(instance.getLabels());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withOwnerReferences(instance.getOwnerReferences());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObjectMetaFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectMeta build() {
    ObjectMeta buildable = new ObjectMeta(fluent.getAnnotations(),fluent.getGenerateName(),fluent.getLabels(),fluent.getName(),fluent.getNamespace(),fluent.getOwnerReferences());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}