package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NutanixResourceIdentifierBuilder extends NutanixResourceIdentifierFluent<NutanixResourceIdentifierBuilder> implements VisitableBuilder<NutanixResourceIdentifier,NutanixResourceIdentifierBuilder>{
  public NutanixResourceIdentifierBuilder() {
    this(false);
  }
  public NutanixResourceIdentifierBuilder(Boolean validationEnabled) {
    this(new NutanixResourceIdentifier(), validationEnabled);
  }
  public NutanixResourceIdentifierBuilder(NutanixResourceIdentifierFluent<?> fluent) {
    this(fluent, false);
  }
  public NutanixResourceIdentifierBuilder(NutanixResourceIdentifierFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NutanixResourceIdentifier(), validationEnabled);
  }
  public NutanixResourceIdentifierBuilder(NutanixResourceIdentifierFluent<?> fluent,NutanixResourceIdentifier instance) {
    this(fluent, instance, false);
  }
  public NutanixResourceIdentifierBuilder(NutanixResourceIdentifierFluent<?> fluent,NutanixResourceIdentifier instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NutanixResourceIdentifier());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withType(instance.getType());
      fluent.withUuid(instance.getUuid());
      fluent.withName(instance.getName());
      fluent.withType(instance.getType());
      fluent.withUuid(instance.getUuid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NutanixResourceIdentifierBuilder(NutanixResourceIdentifier instance) {
    this(instance,false);
  }
  public NutanixResourceIdentifierBuilder(NutanixResourceIdentifier instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NutanixResourceIdentifier());

    if (instance != null) {
      this.withName(instance.getName());
      this.withType(instance.getType());
      this.withUuid(instance.getUuid());
      this.withName(instance.getName());
      this.withType(instance.getType());
      this.withUuid(instance.getUuid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NutanixResourceIdentifierFluent<?> fluent;
  Boolean validationEnabled;
  public NutanixResourceIdentifier build() {
    NutanixResourceIdentifier buildable = new NutanixResourceIdentifier(fluent.getName(),fluent.getType(),fluent.getUuid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}