package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubnetFilterBuilder extends SubnetFilterFluent<SubnetFilterBuilder> implements VisitableBuilder<SubnetFilter,SubnetFilterBuilder>{
  public SubnetFilterBuilder() {
    this(false);
  }
  public SubnetFilterBuilder(Boolean validationEnabled) {
    this(new SubnetFilter(), validationEnabled);
  }
  public SubnetFilterBuilder(SubnetFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public SubnetFilterBuilder(SubnetFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubnetFilter(), validationEnabled);
  }
  public SubnetFilterBuilder(SubnetFilterFluent<?> fluent,SubnetFilter instance) {
    this(fluent, instance, false);
  }
  public SubnetFilterBuilder(SubnetFilterFluent<?> fluent,SubnetFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SubnetFilter());

    if (instance != null) {
      fluent.withCidr(instance.getCidr());
      fluent.withDescription(instance.getDescription());
      fluent.withEnableDhcp(instance.getEnableDhcp());
      fluent.withGatewayIp(instance.getGatewayIp());
      fluent.withId(instance.getId());
      fluent.withIpVersion(instance.getIpVersion());
      fluent.withIpv6AddressMode(instance.getIpv6AddressMode());
      fluent.withIpv6RaMode(instance.getIpv6RaMode());
      fluent.withLimit(instance.getLimit());
      fluent.withMarker(instance.getMarker());
      fluent.withName(instance.getName());
      fluent.withNetworkId(instance.getNetworkId());
      fluent.withNotTags(instance.getNotTags());
      fluent.withNotTagsAny(instance.getNotTagsAny());
      fluent.withProjectId(instance.getProjectId());
      fluent.withSortDir(instance.getSortDir());
      fluent.withSortKey(instance.getSortKey());
      fluent.withSubnetpoolId(instance.getSubnetpoolId());
      fluent.withTags(instance.getTags());
      fluent.withTagsAny(instance.getTagsAny());
      fluent.withTenantId(instance.getTenantId());
      fluent.withCidr(instance.getCidr());
      fluent.withDescription(instance.getDescription());
      fluent.withEnableDhcp(instance.getEnableDhcp());
      fluent.withGatewayIp(instance.getGatewayIp());
      fluent.withId(instance.getId());
      fluent.withIpVersion(instance.getIpVersion());
      fluent.withIpv6AddressMode(instance.getIpv6AddressMode());
      fluent.withIpv6RaMode(instance.getIpv6RaMode());
      fluent.withLimit(instance.getLimit());
      fluent.withMarker(instance.getMarker());
      fluent.withName(instance.getName());
      fluent.withNetworkId(instance.getNetworkId());
      fluent.withNotTags(instance.getNotTags());
      fluent.withNotTagsAny(instance.getNotTagsAny());
      fluent.withProjectId(instance.getProjectId());
      fluent.withSortDir(instance.getSortDir());
      fluent.withSortKey(instance.getSortKey());
      fluent.withSubnetpoolId(instance.getSubnetpoolId());
      fluent.withTags(instance.getTags());
      fluent.withTagsAny(instance.getTagsAny());
      fluent.withTenantId(instance.getTenantId());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubnetFilterBuilder(SubnetFilter instance) {
    this(instance,false);
  }
  public SubnetFilterBuilder(SubnetFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SubnetFilter());

    if (instance != null) {
      this.withCidr(instance.getCidr());
      this.withDescription(instance.getDescription());
      this.withEnableDhcp(instance.getEnableDhcp());
      this.withGatewayIp(instance.getGatewayIp());
      this.withId(instance.getId());
      this.withIpVersion(instance.getIpVersion());
      this.withIpv6AddressMode(instance.getIpv6AddressMode());
      this.withIpv6RaMode(instance.getIpv6RaMode());
      this.withLimit(instance.getLimit());
      this.withMarker(instance.getMarker());
      this.withName(instance.getName());
      this.withNetworkId(instance.getNetworkId());
      this.withNotTags(instance.getNotTags());
      this.withNotTagsAny(instance.getNotTagsAny());
      this.withProjectId(instance.getProjectId());
      this.withSortDir(instance.getSortDir());
      this.withSortKey(instance.getSortKey());
      this.withSubnetpoolId(instance.getSubnetpoolId());
      this.withTags(instance.getTags());
      this.withTagsAny(instance.getTagsAny());
      this.withTenantId(instance.getTenantId());
      this.withCidr(instance.getCidr());
      this.withDescription(instance.getDescription());
      this.withEnableDhcp(instance.getEnableDhcp());
      this.withGatewayIp(instance.getGatewayIp());
      this.withId(instance.getId());
      this.withIpVersion(instance.getIpVersion());
      this.withIpv6AddressMode(instance.getIpv6AddressMode());
      this.withIpv6RaMode(instance.getIpv6RaMode());
      this.withLimit(instance.getLimit());
      this.withMarker(instance.getMarker());
      this.withName(instance.getName());
      this.withNetworkId(instance.getNetworkId());
      this.withNotTags(instance.getNotTags());
      this.withNotTagsAny(instance.getNotTagsAny());
      this.withProjectId(instance.getProjectId());
      this.withSortDir(instance.getSortDir());
      this.withSortKey(instance.getSortKey());
      this.withSubnetpoolId(instance.getSubnetpoolId());
      this.withTags(instance.getTags());
      this.withTagsAny(instance.getTagsAny());
      this.withTenantId(instance.getTenantId());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubnetFilterFluent<?> fluent;
  Boolean validationEnabled;
  public SubnetFilter build() {
    SubnetFilter buildable = new SubnetFilter(fluent.getCidr(),fluent.getDescription(),fluent.getEnableDhcp(),fluent.getGatewayIp(),fluent.getId(),fluent.getIpVersion(),fluent.getIpv6AddressMode(),fluent.getIpv6RaMode(),fluent.getLimit(),fluent.getMarker(),fluent.getName(),fluent.getNetworkId(),fluent.getNotTags(),fluent.getNotTagsAny(),fluent.getProjectId(),fluent.getSortDir(),fluent.getSortKey(),fluent.getSubnetpoolId(),fluent.getTags(),fluent.getTagsAny(),fluent.getTenantId());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}