package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleHookBuilder extends LifecycleHookFluent<LifecycleHookBuilder> implements VisitableBuilder<LifecycleHook,LifecycleHookBuilder>{
  public LifecycleHookBuilder() {
    this(false);
  }
  public LifecycleHookBuilder(Boolean validationEnabled) {
    this(new LifecycleHook(), validationEnabled);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LifecycleHook(), validationEnabled);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,LifecycleHook instance) {
    this(fluent, instance, false);
  }
  public LifecycleHookBuilder(LifecycleHookFluent<?> fluent,LifecycleHook instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LifecycleHook());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withOwner(instance.getOwner());
      fluent.withName(instance.getName());
      fluent.withOwner(instance.getOwner());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LifecycleHookBuilder(LifecycleHook instance) {
    this(instance,false);
  }
  public LifecycleHookBuilder(LifecycleHook instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LifecycleHook());

    if (instance != null) {
      this.withName(instance.getName());
      this.withOwner(instance.getOwner());
      this.withName(instance.getName());
      this.withOwner(instance.getOwner());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LifecycleHookFluent<?> fluent;
  Boolean validationEnabled;
  public LifecycleHook build() {
    LifecycleHook buildable = new LifecycleHook(fluent.getName(),fluent.getOwner());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}