package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineBuilder extends MachineFluent<MachineBuilder> implements VisitableBuilder<Machine,MachineBuilder>{
  public MachineBuilder() {
    this(false);
  }
  public MachineBuilder(Boolean validationEnabled) {
    this(new Machine(), validationEnabled);
  }
  public MachineBuilder(MachineFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineBuilder(MachineFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Machine(), validationEnabled);
  }
  public MachineBuilder(MachineFluent<?> fluent,Machine instance) {
    this(fluent, instance, false);
  }
  public MachineBuilder(MachineFluent<?> fluent,Machine instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Machine());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineBuilder(Machine instance) {
    this(instance,false);
  }
  public MachineBuilder(Machine instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Machine());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineFluent<?> fluent;
  Boolean validationEnabled;
  public Machine build() {
    Machine buildable = new Machine(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}