package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineSetBuilder extends MachineSetFluent<MachineSetBuilder> implements VisitableBuilder<MachineSet,MachineSetBuilder>{
  public MachineSetBuilder() {
    this(false);
  }
  public MachineSetBuilder(Boolean validationEnabled) {
    this(new MachineSet(), validationEnabled);
  }
  public MachineSetBuilder(MachineSetFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineSetBuilder(MachineSetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineSet(), validationEnabled);
  }
  public MachineSetBuilder(MachineSetFluent<?> fluent,MachineSet instance) {
    this(fluent, instance, false);
  }
  public MachineSetBuilder(MachineSetFluent<?> fluent,MachineSet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachineSet());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineSetBuilder(MachineSet instance) {
    this(instance,false);
  }
  public MachineSetBuilder(MachineSet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachineSet());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineSetFluent<?> fluent;
  Boolean validationEnabled;
  public MachineSet build() {
    MachineSet buildable = new MachineSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}