package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineTemplateSpecBuilder extends MachineTemplateSpecFluent<MachineTemplateSpecBuilder> implements VisitableBuilder<MachineTemplateSpec,MachineTemplateSpecBuilder>{
  public MachineTemplateSpecBuilder() {
    this(false);
  }
  public MachineTemplateSpecBuilder(Boolean validationEnabled) {
    this(new MachineTemplateSpec(), validationEnabled);
  }
  public MachineTemplateSpecBuilder(MachineTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineTemplateSpecBuilder(MachineTemplateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineTemplateSpec(), validationEnabled);
  }
  public MachineTemplateSpecBuilder(MachineTemplateSpecFluent<?> fluent,MachineTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public MachineTemplateSpecBuilder(MachineTemplateSpecFluent<?> fluent,MachineTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachineTemplateSpec());

    if (instance != null) {
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineTemplateSpecBuilder(MachineTemplateSpec instance) {
    this(instance,false);
  }
  public MachineTemplateSpecBuilder(MachineTemplateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachineTemplateSpec());

    if (instance != null) {
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineTemplateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachineTemplateSpec build() {
    MachineTemplateSpec buildable = new MachineTemplateSpec(fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}