package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NutanixCategoryBuilder extends NutanixCategoryFluent<NutanixCategoryBuilder> implements VisitableBuilder<NutanixCategory,NutanixCategoryBuilder>{
  public NutanixCategoryBuilder() {
    this(false);
  }
  public NutanixCategoryBuilder(Boolean validationEnabled) {
    this(new NutanixCategory(), validationEnabled);
  }
  public NutanixCategoryBuilder(NutanixCategoryFluent<?> fluent) {
    this(fluent, false);
  }
  public NutanixCategoryBuilder(NutanixCategoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NutanixCategory(), validationEnabled);
  }
  public NutanixCategoryBuilder(NutanixCategoryFluent<?> fluent,NutanixCategory instance) {
    this(fluent, instance, false);
  }
  public NutanixCategoryBuilder(NutanixCategoryFluent<?> fluent,NutanixCategory instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NutanixCategory());

    if (instance != null) {
      fluent.withKey(instance.getKey());
      fluent.withValue(instance.getValue());
      fluent.withKey(instance.getKey());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NutanixCategoryBuilder(NutanixCategory instance) {
    this(instance,false);
  }
  public NutanixCategoryBuilder(NutanixCategory instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NutanixCategory());

    if (instance != null) {
      this.withKey(instance.getKey());
      this.withValue(instance.getValue());
      this.withKey(instance.getKey());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NutanixCategoryFluent<?> fluent;
  Boolean validationEnabled;
  public NutanixCategory build() {
    NutanixCategory buildable = new NutanixCategory(fluent.getKey(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}