package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachineHealthCheckBuilder extends MachineHealthCheckFluent<MachineHealthCheckBuilder> implements VisitableBuilder<MachineHealthCheck,MachineHealthCheckBuilder>{
  public MachineHealthCheckBuilder() {
    this(false);
  }
  public MachineHealthCheckBuilder(Boolean validationEnabled) {
    this(new MachineHealthCheck(), validationEnabled);
  }
  public MachineHealthCheckBuilder(MachineHealthCheckFluent<?> fluent) {
    this(fluent, false);
  }
  public MachineHealthCheckBuilder(MachineHealthCheckFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachineHealthCheck(), validationEnabled);
  }
  public MachineHealthCheckBuilder(MachineHealthCheckFluent<?> fluent,MachineHealthCheck instance) {
    this(fluent, instance, false);
  }
  public MachineHealthCheckBuilder(MachineHealthCheckFluent<?> fluent,MachineHealthCheck instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new MachineHealthCheck());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MachineHealthCheckBuilder(MachineHealthCheck instance) {
    this(instance,false);
  }
  public MachineHealthCheckBuilder(MachineHealthCheck instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new MachineHealthCheck());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MachineHealthCheckFluent<?> fluent;
  Boolean validationEnabled;
  public MachineHealthCheck build() {
    MachineHealthCheck buildable = new MachineHealthCheck(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}