package io.fabric8.openshift.api.model.machine.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OpenStackFailureDomainFluent<A extends OpenStackFailureDomainFluent<A>> extends BaseFluent<A>{
  public OpenStackFailureDomainFluent() {
  }
  
  public OpenStackFailureDomainFluent(OpenStackFailureDomain instance) {
    this.copyInstance(instance);
  }
  private String availabilityZone;
  private RootVolumeBuilder rootVolume;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OpenStackFailureDomain instance) {
    instance = (instance != null ? instance : new OpenStackFailureDomain());
  
    if (instance != null) {
        this.withAvailabilityZone(instance.getAvailabilityZone());
        this.withRootVolume(instance.getRootVolume());
        this.withAvailabilityZone(instance.getAvailabilityZone());
        this.withRootVolume(instance.getRootVolume());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getAvailabilityZone() {
    return this.availabilityZone;
  }
  
  public A withAvailabilityZone(String availabilityZone) {
    this.availabilityZone=availabilityZone; return (A) this;
  }
  
  public boolean hasAvailabilityZone() {
    return this.availabilityZone != null;
  }
  
  public RootVolume buildRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  
  public A withRootVolume(RootVolume rootVolume) {
    _visitables.get("rootVolume").remove(this.rootVolume);
    if (rootVolume!=null){ this.rootVolume= new RootVolumeBuilder(rootVolume); _visitables.get("rootVolume").add(this.rootVolume);} else { this.rootVolume = null; _visitables.get("rootVolume").remove(this.rootVolume); } return (A) this;
  }
  
  public boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  
  public A withNewRootVolume(String availabilityZone) {
    return (A)withRootVolume(new RootVolume(availabilityZone));
  }
  
  public RootVolumeNested<A> withNewRootVolume() {
    return new RootVolumeNested(null);
  }
  
  public RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
    return new RootVolumeNested(item);
  }
  
  public RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(null));
  }
  
  public RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(new RootVolumeBuilder().build()));
  }
  
  public RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
    return withNewRootVolumeLike(java.util.Optional.ofNullable(buildRootVolume()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OpenStackFailureDomainFluent that = (OpenStackFailureDomainFluent) o;
    if (!java.util.Objects.equals(availabilityZone, that.availabilityZone)) return false;
  
    if (!java.util.Objects.equals(rootVolume, that.rootVolume)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(availabilityZone,  rootVolume,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (availabilityZone != null) { sb.append("availabilityZone:"); sb.append(availabilityZone + ","); }
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RootVolumeNested<N> extends RootVolumeFluent<RootVolumeNested<N>> implements Nested<N>{
    RootVolumeNested(RootVolume item) {
      this.builder = new RootVolumeBuilder(this, item);
    }
    RootVolumeBuilder builder;
    
    public N and() {
      return (N) OpenStackFailureDomainFluent.this.withRootVolume(builder.build());
    }
    
    public N endRootVolume() {
      return and();
    }
    
  
  }

}