package io.fabric8.openshift.api.model.machine.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SecurityGroupParamFluent<A extends SecurityGroupParamFluent<A>> extends BaseFluent<A>{
  public SecurityGroupParamFluent() {
  }
  
  public SecurityGroupParamFluent(SecurityGroupParam instance) {
    this.copyInstance(instance);
  }
  private SecurityGroupFilterBuilder filter;
  private String name;
  private String uuid;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SecurityGroupParam instance) {
    instance = (instance != null ? instance : new SecurityGroupParam());
  
    if (instance != null) {
        this.withFilter(instance.getFilter());
        this.withName(instance.getName());
        this.withUuid(instance.getUuid());
        this.withFilter(instance.getFilter());
        this.withName(instance.getName());
        this.withUuid(instance.getUuid());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public SecurityGroupFilter buildFilter() {
    return this.filter!=null ?this.filter.build():null;
  }
  
  public A withFilter(SecurityGroupFilter filter) {
    _visitables.get("filter").remove(this.filter);
    if (filter!=null){ this.filter= new SecurityGroupFilterBuilder(filter); _visitables.get("filter").add(this.filter);} else { this.filter = null; _visitables.get("filter").remove(this.filter); } return (A) this;
  }
  
  public boolean hasFilter() {
    return this.filter != null;
  }
  
  public FilterNested<A> withNewFilter() {
    return new FilterNested(null);
  }
  
  public FilterNested<A> withNewFilterLike(SecurityGroupFilter item) {
    return new FilterNested(item);
  }
  
  public FilterNested<A> editFilter() {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(null));
  }
  
  public FilterNested<A> editOrNewFilter() {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(new SecurityGroupFilterBuilder().build()));
  }
  
  public FilterNested<A> editOrNewFilterLike(SecurityGroupFilter item) {
    return withNewFilterLike(java.util.Optional.ofNullable(buildFilter()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getUuid() {
    return this.uuid;
  }
  
  public A withUuid(String uuid) {
    this.uuid=uuid; return (A) this;
  }
  
  public boolean hasUuid() {
    return this.uuid != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SecurityGroupParamFluent that = (SecurityGroupParamFluent) o;
    if (!java.util.Objects.equals(filter, that.filter)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(uuid, that.uuid)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(filter,  name,  uuid,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (filter != null) { sb.append("filter:"); sb.append(filter + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (uuid != null) { sb.append("uuid:"); sb.append(uuid + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FilterNested<N> extends SecurityGroupFilterFluent<FilterNested<N>> implements Nested<N>{
    FilterNested(SecurityGroupFilter item) {
      this.builder = new SecurityGroupFilterBuilder(this, item);
    }
    SecurityGroupFilterBuilder builder;
    
    public N and() {
      return (N) SecurityGroupParamFluent.this.withFilter(builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }

}